"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    parameter_group_name: str,
    parameter_group_family: str,
    description: str,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an Amazon Redshift parameter group. Creating parameter groups is independent of creating clusters. You can associate a cluster with a parameter group when you create the cluster. You can also associate an existing cluster with a parameter group after the cluster is created by using ModifyCluster.  Parameters in the parameter group define specific behavior that applies to the databases you create on the cluster. For more information about parameters and parameter groups, go to Amazon Redshift Parameter Groups in the Amazon Redshift Cluster Management Guide.

    Args:
        parameter_group_name(str): The name of the cluster parameter group. Constraints:   Must be 1 to 255 alphanumeric characters or hyphens   First character must be a letter.   Cannot end with a hyphen or contain two consecutive hyphens.   Must be unique withing your Amazon Web Services account.    This value is stored as a lower-case string. .
        parameter_group_family(str): The Amazon Redshift engine version to which the cluster parameter group applies. The cluster engine version determines the set of parameters. To get a list of valid parameter group family names, you can call DescribeClusterParameterGroups. By default, Amazon Redshift returns a list of all the parameter groups that are owned by your Amazon Web Services account, including the default parameter groups for each Amazon Redshift engine version. The parameter group family names associated with the default parameter groups provide you the valid values. For example, a valid family name is "redshift-1.0". .
        description(str): A description of the parameter group.
        tags(List, optional): A list of tag instances. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.cluster.parameter.group.create(
                ctx, parameter_group_name=value, parameter_group_family=value, description=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.cluster.parameter.group.create parameter_group_name=value, parameter_group_family=value, description=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="create_cluster_parameter_group",
        op_kwargs={
            "ParameterGroupName": parameter_group_name,
            "ParameterGroupFamily": parameter_group_family,
            "Description": description,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, parameter_group_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a specified Amazon Redshift parameter group.  You cannot delete a parameter group if it is associated with a cluster.

    Args:
        parameter_group_name(str): The name of the parameter group to be deleted. Constraints:   Must be the name of an existing cluster parameter group.   Cannot delete a default cluster parameter group.  .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.cluster.parameter.group.delete(
                ctx, parameter_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.cluster.parameter.group.delete parameter_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="delete_cluster_parameter_group",
        op_kwargs={"ParameterGroupName": parameter_group_name},
    )


async def describe_all(
    hub,
    ctx,
    parameter_group_name: str = None,
    max_records: int = None,
    marker: str = None,
    tag_keys: List = None,
    tag_values: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of Amazon Redshift parameter groups, including parameter groups you created and the default parameter group. For each parameter group, the response includes the parameter group name, description, and parameter group family name. You can optionally specify a name to retrieve the description of a specific parameter group.  For more information about parameters and parameter groups, go to Amazon Redshift Parameter Groups in the Amazon Redshift Cluster Management Guide. If you specify both tag keys and tag values in the same request, Amazon Redshift returns all parameter groups that match any combination of the specified keys and values. For example, if you have owner and environment for tag keys, and admin and test for tag values, all parameter groups that have any combination of those values are returned. If both tag keys and values are omitted from the request, parameter groups are returned regardless of whether they have tag keys or values associated with them.

    Args:
        parameter_group_name(str, optional): The name of a specific parameter group for which to return details. By default, details about all parameter groups and the default parameter group are returned. Defaults to None.
        max_records(int, optional): The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified MaxRecords value, a value is returned in a marker field of the response. You can retrieve the next set of records by retrying the command with the returned marker value.  Default: 100  Constraints: minimum 20, maximum 100. Defaults to None.
        marker(str, optional): An optional parameter that specifies the starting point to return a set of response records. When the results of a DescribeClusterParameterGroups request exceed the value specified in MaxRecords, Amazon Web Services returns a value in the Marker field of the response. You can retrieve the next set of response records by providing the returned marker value in the Marker parameter and retrying the request. . Defaults to None.
        tag_keys(List, optional): A tag key or keys for which you want to return all matching cluster parameter groups that are associated with the specified key or keys. For example, suppose that you have parameter groups that are tagged with keys called owner and environment. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the parameter groups that have either or both of these tag keys associated with them. Defaults to None.
        tag_values(List, optional): A tag value or values for which you want to return all matching cluster parameter groups that are associated with the specified tag value or values. For example, suppose that you have parameter groups that are tagged with values called admin and test. If you specify both of these tag values in the request, Amazon Redshift returns a response with the parameter groups that have either or both of these tag values associated with them. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.cluster.parameter.group.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.cluster.parameter.group.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="describe_cluster_parameter_groups",
        op_kwargs={
            "ParameterGroupName": parameter_group_name,
            "MaxRecords": max_records,
            "Marker": marker,
            "TagKeys": tag_keys,
            "TagValues": tag_values,
        },
    )


async def modify(hub, ctx, parameter_group_name: str, parameters: List) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the parameters of a parameter group. For the parameters parameter, it can't contain ASCII characters.  For more information about parameters and parameter groups, go to Amazon Redshift Parameter Groups in the Amazon Redshift Cluster Management Guide.

    Args:
        parameter_group_name(str): The name of the parameter group to be modified.
        parameters(List): An array of parameters to be modified. A maximum of 20 parameters can be modified in a single request. For each parameter to be modified, you must supply at least the parameter name and parameter value; other name-value pairs of the parameter are optional. For the workload management (WLM) configuration, you must supply all the name-value pairs in the wlm_json_configuration parameter.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.cluster.parameter.group.modify(
                ctx, parameter_group_name=value, parameters=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.cluster.parameter.group.modify parameter_group_name=value, parameters=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="modify_cluster_parameter_group",
        op_kwargs={
            "ParameterGroupName": parameter_group_name,
            "Parameters": parameters,
        },
    )


async def reset(
    hub,
    ctx,
    parameter_group_name: str,
    reset_all_parameters: bool = None,
    parameters: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Sets one or more parameters of the specified parameter group to their default values and sets the source values of the parameters to "engine-default". To reset the entire parameter group specify the ResetAllParameters parameter. For parameter changes to take effect you must reboot any associated clusters.

    Args:
        parameter_group_name(str): The name of the cluster parameter group to be reset.
        reset_all_parameters(bool, optional): If true, all parameters in the specified parameter group will be reset to their default values.  Default: true . Defaults to None.
        parameters(List, optional): An array of names of parameters to be reset. If ResetAllParameters option is not used, then at least one parameter name must be supplied.  Constraints: A maximum of 20 parameters can be reset in a single request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.cluster.parameter.group.reset(
                ctx, parameter_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.cluster.parameter.group.reset parameter_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="reset_cluster_parameter_group",
        op_kwargs={
            "ParameterGroupName": parameter_group_name,
            "ResetAllParameters": reset_all_parameters,
            "Parameters": parameters,
        },
    )
