"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def modify(
    hub,
    ctx,
    cluster_identifier: str,
    defer_maintenance: bool = None,
    defer_maintenance_identifier: str = None,
    defer_maintenance_start_time: str = None,
    defer_maintenance_end_time: str = None,
    defer_maintenance_duration: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the maintenance settings of a cluster.

    Args:
        cluster_identifier(str): A unique identifier for the cluster.
        defer_maintenance(bool, optional): A boolean indicating whether to enable the deferred maintenance window. . Defaults to None.
        defer_maintenance_identifier(str, optional): A unique identifier for the deferred maintenance window. Defaults to None.
        defer_maintenance_start_time(str, optional): A timestamp indicating the start time for the deferred maintenance window. Defaults to None.
        defer_maintenance_end_time(str, optional): A timestamp indicating end time for the deferred maintenance window. If you specify an end time, you can't specify a duration. Defaults to None.
        defer_maintenance_duration(int, optional): An integer indicating the duration of the maintenance window in days. If you specify a duration, you can't specify an end time. The duration must be 45 days or less. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.cluster.maintenance.modify(
                ctx, cluster_identifier=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.cluster.maintenance.modify cluster_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="modify_cluster_maintenance",
        op_kwargs={
            "ClusterIdentifier": cluster_identifier,
            "DeferMaintenance": defer_maintenance,
            "DeferMaintenanceIdentifier": defer_maintenance_identifier,
            "DeferMaintenanceStartTime": defer_maintenance_start_time,
            "DeferMaintenanceEndTime": defer_maintenance_end_time,
            "DeferMaintenanceDuration": defer_maintenance_duration,
        },
    )
