"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def modify(
    hub,
    ctx,
    cluster_identifier: str,
    add_iam_roles: List = None,
    remove_iam_roles: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the list of Identity and Access Management (IAM) roles that can be used by the cluster to access other Amazon Web Services services. A cluster can have up to 10 IAM roles associated at any time.

    Args:
        cluster_identifier(str): The unique identifier of the cluster for which you want to associate or disassociate IAM roles.
        add_iam_roles(List, optional): Zero or more IAM roles to associate with the cluster. The roles must be in their Amazon Resource Name (ARN) format. You can associate up to 10 IAM roles with a single cluster in a single request. Defaults to None.
        remove_iam_roles(List, optional): Zero or more IAM roles in ARN format to disassociate from the cluster. You can disassociate up to 10 IAM roles from a single cluster in a single request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.cluster.iam_role.modify(ctx, cluster_identifier=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.cluster.iam_role.modify cluster_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="modify_cluster_iam_roles",
        op_kwargs={
            "ClusterIdentifier": cluster_identifier,
            "AddIamRoles": add_iam_roles,
            "RemoveIamRoles": remove_iam_roles,
        },
    )
