"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub,
    ctx,
    cluster_identifier: str = None,
    max_records: int = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns an array of ClusterDbRevision objects.

    Args:
        cluster_identifier(str, optional): A unique identifier for a cluster whose ClusterDbRevisions you are requesting. This parameter is case sensitive. All clusters defined for an account are returned by default. Defaults to None.
        max_records(int, optional): The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified MaxRecords value, a value is returned in the marker field of the response. You can retrieve the next set of response records by providing the returned marker value in the marker parameter and retrying the request.  Default: 100 Constraints: minimum 20, maximum 100. Defaults to None.
        marker(str, optional): An optional parameter that specifies the starting point for returning a set of response records. When the results of a DescribeClusterDbRevisions request exceed the value specified in MaxRecords, Amazon Redshift returns a value in the marker field of the response. You can retrieve the next set of response records by providing the returned marker value in the marker parameter and retrying the request.  Constraints: You can specify either the ClusterIdentifier parameter, or the marker parameter, but not both. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.cluster.db_revision.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.cluster.db_revision.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="describe_cluster_db_revisions",
        op_kwargs={
            "ClusterIdentifier": cluster_identifier,
            "MaxRecords": max_records,
            "Marker": marker,
        },
    )


async def modify(hub, ctx, cluster_identifier: str, revision_target: str) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the database revision of a cluster. The database revision is a unique revision of the database running in a cluster.

    Args:
        cluster_identifier(str): The unique identifier of a cluster whose database revision you want to modify.  Example: examplecluster .
        revision_target(str): The identifier of the database revision. You can retrieve this value from the response to the DescribeClusterDbRevisions request.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.cluster.db_revision.modify(
                ctx, cluster_identifier=value, revision_target=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.cluster.db_revision.modify cluster_identifier=value, revision_target=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="modify_cluster_db_revision",
        op_kwargs={
            "ClusterIdentifier": cluster_identifier,
            "RevisionTarget": revision_target,
        },
    )
