"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, authentication_profile_name: str, authentication_profile_content: str
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an authentication profile with the specified parameters.

    Args:
        authentication_profile_name(str): The name of the authentication profile to be created.
        authentication_profile_content(str): The content of the authentication profile in JSON format. The maximum length of the JSON string is determined by a quota for your account.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.authentication_profile.create(
                ctx, authentication_profile_name=value, authentication_profile_content=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.authentication_profile.create authentication_profile_name=value, authentication_profile_content=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="create_authentication_profile",
        op_kwargs={
            "AuthenticationProfileName": authentication_profile_name,
            "AuthenticationProfileContent": authentication_profile_content,
        },
    )


async def delete(hub, ctx, authentication_profile_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an authentication profile.

    Args:
        authentication_profile_name(str): The name of the authentication profile to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.authentication_profile.delete(
                ctx, authentication_profile_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.authentication_profile.delete authentication_profile_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="delete_authentication_profile",
        op_kwargs={"AuthenticationProfileName": authentication_profile_name},
    )


async def describe_all(hub, ctx, authentication_profile_name: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Describes an authentication profile.

    Args:
        authentication_profile_name(str, optional): The name of the authentication profile to describe. If not specified then all authentication profiles owned by the account are listed. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.authentication_profile.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.authentication_profile.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="describe_authentication_profiles",
        op_kwargs={"AuthenticationProfileName": authentication_profile_name},
    )


async def modify(
    hub, ctx, authentication_profile_name: str, authentication_profile_content: str
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies an authentication profile.

    Args:
        authentication_profile_name(str): The name of the authentication profile to replace.
        authentication_profile_content(str): The new content of the authentication profile in JSON format. The maximum length of the JSON string is determined by a quota for your account.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.redshift.authentication_profile.modify(
                ctx, authentication_profile_name=value, authentication_profile_content=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.redshift.authentication_profile.modify authentication_profile_name=value, authentication_profile_content=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="redshift",
        operation="modify_authentication_profile",
        op_kwargs={
            "AuthenticationProfileName": authentication_profile_name,
            "AuthenticationProfileContent": authentication_profile_content,
        },
    )
