"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def begin(
    hub,
    ctx,
    resource_arn: str,
    secret_arn: str,
    database: str = None,
    schema: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts a SQL transaction.  <important> <p>A transaction can run for a maximum of 24 hours. A transaction is terminated and rolled back automatically after 24 hours.</p> <p>A transaction times out if no calls use its transaction ID in three minutes. If a transaction times out before it's committed, it's rolled back automatically.</p> <p>DDL statements inside a transaction cause an implicit commit. We recommend that you run each DDL statement in a separate <code>ExecuteStatement</code> call with <code>continueAfterTimeout</code> enabled.</p> </important>

    Args:
        database(str, optional): The name of the database. Defaults to None.
        resource_arn(str): The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.
        schema(str, optional): The name of the database schema. Defaults to None.
        secret_arn(str): The name or ARN of the secret that enables access to the DB cluster.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds_data.transaction.begin(
                ctx, resource_arn=value, secret_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds_data.transaction.begin resource_arn=value, secret_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds-data",
        operation="begin_transaction",
        op_kwargs={
            "database": database,
            "resourceArn": resource_arn,
            "schema": schema,
            "secretArn": secret_arn,
        },
    )


async def commit(
    hub, ctx, resource_arn: str, secret_arn: str, transaction_id: str
) -> Dict:
    r"""
    **Autogenerated function**

    Ends a SQL transaction started with the BeginTransaction operation and commits the changes.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.
        secret_arn(str): The name or ARN of the secret that enables access to the DB cluster.
        transaction_id(str): The identifier of the transaction to end and commit.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds_data.transaction.commit(
                ctx, resource_arn=value, secret_arn=value, transaction_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds_data.transaction.commit resource_arn=value, secret_arn=value, transaction_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds-data",
        operation="commit_transaction",
        op_kwargs={
            "resourceArn": resource_arn,
            "secretArn": secret_arn,
            "transactionId": transaction_id,
        },
    )


async def rollback(
    hub, ctx, resource_arn: str, secret_arn: str, transaction_id: str
) -> Dict:
    r"""
    **Autogenerated function**

    Performs a rollback of a transaction. Rolling back a transaction cancels its changes.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.
        secret_arn(str): The name or ARN of the secret that enables access to the DB cluster.
        transaction_id(str): The identifier of the transaction to roll back.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds_data.transaction.rollback(
                ctx, resource_arn=value, secret_arn=value, transaction_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds_data.transaction.rollback resource_arn=value, secret_arn=value, transaction_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds-data",
        operation="rollback_transaction",
        op_kwargs={
            "resourceArn": resource_arn,
            "secretArn": secret_arn,
            "transactionId": transaction_id,
        },
    )
