"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def execute(
    hub,
    ctx,
    resource_arn: str,
    secret_arn: str,
    sql: str,
    continue_after_timeout: bool = None,
    database: str = None,
    include_result_metadata: bool = None,
    parameters: List = None,
    result_set_options: Dict = None,
    schema: str = None,
    transaction_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Runs a SQL statement against a database.  If a call isn't part of a transaction because it doesn't include the transactionID parameter, changes that result from the call are committed automatically.  The response size limit is 1 MB. If the call returns more than 1 MB of response data, the call is terminated.

    Args:
        continue_after_timeout(bool, optional): A value that indicates whether to continue running the statement after the call times out. By default, the statement stops running when the call times out.  For DDL statements, we recommend continuing to run the statement after the call times out. When a DDL statement terminates before it is finished running, it can result in errors and possibly corrupted data structures. . Defaults to None.
        database(str, optional): The name of the database. Defaults to None.
        include_result_metadata(bool, optional): A value that indicates whether to include metadata in the results. Defaults to None.
        parameters(List, optional): The parameters for the SQL statement.  Array parameters are not supported. . Defaults to None.
        resource_arn(str): The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.
        result_set_options(Dict, optional): Options that control how the result set is returned. Defaults to None.
        schema(str, optional): The name of the database schema.  Currently, the schema parameter isn't supported. . Defaults to None.
        secret_arn(str): The name or ARN of the secret that enables access to the DB cluster.
        sql(str): The SQL statement to run.
        transaction_id(str, optional): The identifier of a transaction that was started by using the BeginTransaction operation. Specify the transaction ID of the transaction that you want to include the SQL statement in. If the SQL statement is not part of a transaction, don't set this parameter. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds_data.statement.execute(
                ctx, resource_arn=value, secret_arn=value, sql=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds_data.statement.execute resource_arn=value, secret_arn=value, sql=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds-data",
        operation="execute_statement",
        op_kwargs={
            "continueAfterTimeout": continue_after_timeout,
            "database": database,
            "includeResultMetadata": include_result_metadata,
            "parameters": parameters,
            "resourceArn": resource_arn,
            "resultSetOptions": result_set_options,
            "schema": schema,
            "secretArn": secret_arn,
            "sql": sql,
            "transactionId": transaction_id,
        },
    )
