"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def execute(
    hub,
    ctx,
    aws_secret_store_arn: str,
    db_cluster_or_instance_arn: str,
    sql_statements: str,
    database: str = None,
    schema: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Runs one or more SQL statements.  This operation is deprecated. Use the BatchExecuteStatement or ExecuteStatement operation.

    Args:
        aws_secret_store_arn(str): The Amazon Resource Name (ARN) of the secret that enables access to the DB cluster.
        database(str, optional): The name of the database. Defaults to None.
        db_cluster_or_instance_arn(str): The ARN of the Aurora Serverless DB cluster.
        schema(str, optional): The name of the database schema. Defaults to None.
        sql_statements(str): One or more SQL statements to run on the DB cluster. You can separate SQL statements from each other with a semicolon (;). Any valid SQL statement is permitted, including data definition, data manipulation, and commit statements. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds_data.sql.execute(
                ctx,
                aws_secret_store_arn=value,
                db_cluster_or_instance_arn=value,
                sql_statements=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds_data.sql.execute aws_secret_store_arn=value, db_cluster_or_instance_arn=value, sql_statements=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds-data",
        operation="execute_sql",
        op_kwargs={
            "awsSecretStoreArn": aws_secret_store_arn,
            "database": database,
            "dbClusterOrInstanceArn": db_cluster_or_instance_arn,
            "schema": schema,
            "sqlStatements": sql_statements,
        },
    )
