"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(
    hub,
    ctx,
    resource_arn: str,
    secret_arn: str,
    sql: str,
    database: str = None,
    parameter_sets: List = None,
    schema: str = None,
    transaction_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Runs a batch SQL statement over an array of data. You can run bulk update and insert operations for multiple records using a DML statement with different parameter sets. Bulk operations can provide a significant performance improvement over individual insert and update operations.  If a call isn't part of a transaction because it doesn't include the transactionID parameter, changes that result from the call are committed automatically.

    Args:
        database(str, optional): The name of the database. Defaults to None.
        parameter_sets(List, optional): The parameter set for the batch operation. The SQL statement is executed as many times as the number of parameter sets provided. To execute a SQL statement with no parameters, use one of the following options:   Specify one or more empty parameter sets.   Use the ExecuteStatement operation instead of the BatchExecuteStatement operation.    Array parameters are not supported. . Defaults to None.
        resource_arn(str): The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.
        schema(str, optional): The name of the database schema. Defaults to None.
        secret_arn(str): The name or ARN of the secret that enables access to the DB cluster.
        sql(str): The SQL statement to run.
        transaction_id(str, optional): The identifier of a transaction that was started by using the BeginTransaction operation. Specify the transaction ID of the transaction that you want to include the SQL statement in. If the SQL statement is not part of a transaction, don't set this parameter. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds_data.execute_statement.batch(
                ctx, resource_arn=value, secret_arn=value, sql=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds_data.execute_statement.batch resource_arn=value, secret_arn=value, sql=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds-data",
        operation="batch_execute_statement",
        op_kwargs={
            "database": database,
            "parameterSets": parameter_sets,
            "resourceArn": resource_arn,
            "schema": schema,
            "secretArn": secret_arn,
            "sql": sql,
            "transactionId": transaction_id,
        },
    )
