"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import List


async def remove(hub, ctx, resource_name: str, tag_keys: List) -> None:
    r"""
    **Autogenerated function**

    Removes metadata tags from an Amazon RDS resource. For an overview on tagging an Amazon RDS resource, see Tagging Amazon RDS Resources in the Amazon RDS User Guide.

    Args:
        resource_name(str): The Amazon RDS resource that the tags are removed from. This value is an Amazon Resource Name (ARN). For information about creating an ARN, see  Constructing an ARN for Amazon RDS in the Amazon RDS User Guide. .
        tag_keys(List): The tag key (name) of the tag to be removed.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.tags.from_resource.remove(
                ctx, resource_name=value, tag_keys=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.tags.from_resource.remove resource_name=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="remove_tags_from_resource",
        op_kwargs={"ResourceName": resource_name, "TagKeys": tag_keys},
    )
