"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def add(hub, ctx, subscription_name: str, source_identifier: str) -> Dict:
    r"""
    **Autogenerated function**

    Adds a source identifier to an existing RDS event notification subscription.

    Args:
        subscription_name(str): The name of the RDS event notification subscription you want to add a source identifier to.
        source_identifier(str): The identifier of the event source to be added. Constraints:   If the source type is a DB instance, a DBInstanceIdentifier value must be supplied.   If the source type is a DB cluster, a DBClusterIdentifier value must be supplied.   If the source type is a DB parameter group, a DBParameterGroupName value must be supplied.   If the source type is a DB security group, a DBSecurityGroupName value must be supplied.   If the source type is a DB snapshot, a DBSnapshotIdentifier value must be supplied.   If the source type is a DB cluster snapshot, a DBClusterSnapshotIdentifier value must be supplied.  .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.source.identifier.to_subscription.add(
                ctx, subscription_name=value, source_identifier=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.source.identifier.to_subscription.add subscription_name=value, source_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="add_source_identifier_to_subscription",
        op_kwargs={
            "SubscriptionName": subscription_name,
            "SourceIdentifier": source_identifier,
        },
    )
