"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def add(
    hub, ctx, db_instance_identifier: str, role_arn: str, feature_name: str
) -> None:
    r"""
    **Autogenerated function**

    Associates an Amazon Web Services Identity and Access Management (IAM) role with a DB instance.  To add a role to a DB instance, the status of the DB instance must be available.

    Args:
        db_instance_identifier(str): The name of the DB instance to associate the IAM role with.
        role_arn(str): The Amazon Resource Name (ARN) of the IAM role to associate with the DB instance, for example arn:aws:iam::123456789012:role/AccessRole. .
        feature_name(str): The name of the feature for the DB instance that the IAM role is to be associated with. For the list of supported feature names, see DBEngineVersion. .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.role.to_db.instance.add(
                ctx, db_instance_identifier=value, role_arn=value, feature_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.role.to_db.instance.add db_instance_identifier=value, role_arn=value, feature_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="add_role_to_db_instance",
        op_kwargs={
            "DBInstanceIdentifier": db_instance_identifier,
            "RoleArn": role_arn,
            "FeatureName": feature_name,
        },
    )
