"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def add(
    hub, ctx, db_cluster_identifier: str, role_arn: str, feature_name: str = None
) -> None:
    r"""
    **Autogenerated function**

    Associates an Identity and Access Management (IAM) role from an Amazon Aurora DB cluster. For more information, see Authorizing Amazon Aurora MySQL to Access Other Amazon Web Services Services on Your Behalf in the Amazon Aurora User Guide.  This action only applies to Aurora DB clusters.

    Args:
        db_cluster_identifier(str): The name of the DB cluster to associate the IAM role with.
        role_arn(str): The Amazon Resource Name (ARN) of the IAM role to associate with the Aurora DB cluster, for example, arn:aws:iam::123456789012:role/AuroraAccessRole.
        feature_name(str, optional): The name of the feature for the DB cluster that the IAM role is to be associated with. For the list of supported feature names, see DBEngineVersion. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.role.to_db.cluster.add(
                ctx, db_cluster_identifier=value, role_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.role.to_db.cluster.add db_cluster_identifier=value, role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="add_role_to_db_cluster",
        op_kwargs={
            "DBClusterIdentifier": db_cluster_identifier,
            "RoleArn": role_arn,
            "FeatureName": feature_name,
        },
    )
