"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def remove(
    hub, ctx, db_instance_identifier: str, role_arn: str, feature_name: str
) -> None:
    r"""
    **Autogenerated function**

    Disassociates an Amazon Web Services Identity and Access Management (IAM) role from a DB instance.

    Args:
        db_instance_identifier(str): The name of the DB instance to disassociate the IAM role from.
        role_arn(str): The Amazon Resource Name (ARN) of the IAM role to disassociate from the DB instance, for example, arn:aws:iam::123456789012:role/AccessRole.
        feature_name(str): The name of the feature for the DB instance that the IAM role is to be disassociated from. For the list of supported feature names, see DBEngineVersion. .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.role.from_db.instance.remove(
                ctx, db_instance_identifier=value, role_arn=value, feature_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.role.from_db.instance.remove db_instance_identifier=value, role_arn=value, feature_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="remove_role_from_db_instance",
        op_kwargs={
            "DBInstanceIdentifier": db_instance_identifier,
            "RoleArn": role_arn,
            "FeatureName": feature_name,
        },
    )
