"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    reserved_db_instances_offering_id: str = None,
    db_instance_class: str = None,
    duration: str = None,
    product_description: str = None,
    offering_type: str = None,
    multi_az: bool = None,
    filters: List = None,
    max_records: int = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists available reserved DB instance offerings.

    Args:
        reserved_db_instances_offering_id(str, optional): The offering identifier filter value. Specify this parameter to show only the available offering that matches the specified reservation identifier. Example: 438012d3-4052-4cc7-b2e3-8d3372e0e706 . Defaults to None.
        db_instance_class(str, optional): The DB instance class filter value. Specify this parameter to show only the available offerings matching the specified DB instance class. Defaults to None.
        duration(str, optional): Duration filter value, specified in years or seconds. Specify this parameter to show only reservations for this duration. Valid Values: 1 | 3 | 31536000 | 94608000 . Defaults to None.
        product_description(str, optional): Product description filter value. Specify this parameter to show only the available offerings that contain the specified product description.  The results show offerings that partially match the filter value. . Defaults to None.
        offering_type(str, optional): The offering type filter value. Specify this parameter to show only the available offerings matching the specified offering type. Valid Values: "Partial Upfront" | "All Upfront" | "No Upfront"  . Defaults to None.
        multi_az(bool, optional): A value that indicates whether to show only those reservations that support Multi-AZ. Defaults to None.
        filters(List, optional): This parameter isn't currently supported. Defaults to None.
        max_records(int, optional):  The maximum number of records to include in the response. If more than the MaxRecords value is available, a pagination token called a marker is included in the response so you can retrieve the remaining results.  Default: 100 Constraints: Minimum 20, maximum 100. Defaults to None.
        marker(str, optional):  An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.reserved_db_instance.offering.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.reserved_db_instance.offering.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="describe_reserved_db_instances_offerings",
        op_kwargs={
            "ReservedDBInstancesOfferingId": reserved_db_instances_offering_id,
            "DBInstanceClass": db_instance_class,
            "Duration": duration,
            "ProductDescription": product_description,
            "OfferingType": offering_type,
            "MultiAZ": multi_az,
            "Filters": filters,
            "MaxRecords": max_records,
            "Marker": marker,
        },
    )


async def purchase(
    hub,
    ctx,
    reserved_db_instances_offering_id: str,
    reserved_db_instance_id: str = None,
    db_instance_count: int = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Purchases a reserved DB instance offering.

    Args:
        reserved_db_instances_offering_id(str): The ID of the Reserved DB instance offering to purchase. Example: 438012d3-4052-4cc7-b2e3-8d3372e0e706.
        reserved_db_instance_id(str, optional): Customer-specified identifier to track this reservation. Example: myreservationID. Defaults to None.
        db_instance_count(int, optional): The number of instances to reserve. Default: 1 . Defaults to None.
        tags(List, optional): A list of tags. For more information, see Tagging Amazon RDS Resources in the Amazon RDS User Guide. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.reserved_db_instance.offering.purchase(
                ctx, reserved_db_instances_offering_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.reserved_db_instance.offering.purchase reserved_db_instances_offering_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="purchase_reserved_db_instances_offering",
        op_kwargs={
            "ReservedDBInstancesOfferingId": reserved_db_instances_offering_id,
            "ReservedDBInstanceId": reserved_db_instance_id,
            "DBInstanceCount": db_instance_count,
            "Tags": tags,
        },
    )
