"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    reserved_db_instance_id: str = None,
    reserved_db_instances_offering_id: str = None,
    db_instance_class: str = None,
    duration: str = None,
    product_description: str = None,
    offering_type: str = None,
    multi_az: bool = None,
    lease_id: str = None,
    filters: List = None,
    max_records: int = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about reserved DB instances for this account, or about a specified reserved DB instance.

    Args:
        reserved_db_instance_id(str, optional): The reserved DB instance identifier filter value. Specify this parameter to show only the reservation that matches the specified reservation ID. Defaults to None.
        reserved_db_instances_offering_id(str, optional): The offering identifier filter value. Specify this parameter to show only purchased reservations matching the specified offering identifier. Defaults to None.
        db_instance_class(str, optional): The DB instance class filter value. Specify this parameter to show only those reservations matching the specified DB instances class. Defaults to None.
        duration(str, optional): The duration filter value, specified in years or seconds. Specify this parameter to show only reservations for this duration. Valid Values: 1 | 3 | 31536000 | 94608000 . Defaults to None.
        product_description(str, optional): The product description filter value. Specify this parameter to show only those reservations matching the specified product description. Defaults to None.
        offering_type(str, optional): The offering type filter value. Specify this parameter to show only the available offerings matching the specified offering type. Valid Values: "Partial Upfront" | "All Upfront" | "No Upfront"  . Defaults to None.
        multi_az(bool, optional): A value that indicates whether to show only those reservations that support Multi-AZ. Defaults to None.
        lease_id(str, optional): The lease identifier filter value. Specify this parameter to show only the reservation that matches the specified lease ID.  Amazon Web Services Support might request the lease ID for an issue related to a reserved DB instance. . Defaults to None.
        filters(List, optional): This parameter isn't currently supported. Defaults to None.
        max_records(int, optional):  The maximum number of records to include in the response. If more than the MaxRecords value is available, a pagination token called a marker is included in the response so you can retrieve the remaining results.  Default: 100 Constraints: Minimum 20, maximum 100. Defaults to None.
        marker(str, optional):  An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.reserved_db_instance.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.reserved_db_instance.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="describe_reserved_db_instances",
        op_kwargs={
            "ReservedDBInstanceId": reserved_db_instance_id,
            "ReservedDBInstancesOfferingId": reserved_db_instances_offering_id,
            "DBInstanceClass": db_instance_class,
            "Duration": duration,
            "ProductDescription": product_description,
            "OfferingType": offering_type,
            "MultiAZ": multi_az,
            "LeaseId": lease_id,
            "Filters": filters,
            "MaxRecords": max_records,
            "Marker": marker,
        },
    )
