"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def promote(hub, ctx, db_cluster_identifier: str) -> Dict:
    r"""
    **Autogenerated function**

    Promotes a read replica DB cluster to a standalone DB cluster.  This action only applies to Aurora DB clusters.

    Args:
        db_cluster_identifier(str): The identifier of the DB cluster read replica to promote. This parameter isn't case-sensitive.  Constraints:   Must match the identifier of an existing DB cluster read replica.   Example: my-cluster-replica1 .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.read_replica.db_cluster.promote(
                ctx, db_cluster_identifier=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.read_replica.db_cluster.promote db_cluster_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="promote_read_replica_db_cluster",
        op_kwargs={"DBClusterIdentifier": db_cluster_identifier},
    )
