"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    engine_name: str,
    major_engine_version: str = None,
    filters: List = None,
    max_records: int = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes all available options.

    Args:
        engine_name(str): A required parameter. Options available for the given engine name are described. Valid Values:     mariadb     mysql     oracle-ee     oracle-ee-cdb     oracle-se2     oracle-se2-cdb     postgres     sqlserver-ee     sqlserver-se     sqlserver-ex     sqlserver-web   .
        major_engine_version(str, optional): If specified, filters the results to include only options for the specified major engine version. Defaults to None.
        filters(List, optional): This parameter isn't currently supported. Defaults to None.
        max_records(int, optional):  The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.  Default: 100 Constraints: Minimum 20, maximum 100. Defaults to None.
        marker(str, optional): An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.option_group.option.describe_all(ctx, engine_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.option_group.option.describe_all engine_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="describe_option_group_options",
        op_kwargs={
            "EngineName": engine_name,
            "MajorEngineVersion": major_engine_version,
            "Filters": filters,
            "MaxRecords": max_records,
            "Marker": marker,
        },
    )
