"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def copy(
    hub,
    ctx,
    source_option_group_identifier: str,
    target_option_group_identifier: str,
    target_option_group_description: str,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Copies the specified option group.

    Args:
        source_option_group_identifier(str): The identifier for the source option group.  Constraints:   Must specify a valid option group.  .
        target_option_group_identifier(str): The identifier for the copied option group. Constraints:   Can't be null, empty, or blank   Must contain from 1 to 255 letters, numbers, or hyphens   First character must be a letter   Can't end with a hyphen or contain two consecutive hyphens   Example: my-option-group .
        target_option_group_description(str): The description for the copied option group.
        tags(List, optional): A list of tags. For more information, see Tagging Amazon RDS Resources in the Amazon RDS User Guide. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.option_group.init.copy(
                ctx,
                source_option_group_identifier=value,
                target_option_group_identifier=value,
                target_option_group_description=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.option_group.init.copy source_option_group_identifier=value, target_option_group_identifier=value, target_option_group_description=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="copy_option_group",
        op_kwargs={
            "SourceOptionGroupIdentifier": source_option_group_identifier,
            "TargetOptionGroupIdentifier": target_option_group_identifier,
            "TargetOptionGroupDescription": target_option_group_description,
            "Tags": tags,
        },
    )


async def create(
    hub,
    ctx,
    option_group_name: str,
    engine_name: str,
    major_engine_version: str,
    option_group_description: str,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new option group. You can create up to 20 option groups.

    Args:
        option_group_name(str): Specifies the name of the option group to be created. Constraints:   Must be 1 to 255 letters, numbers, or hyphens   First character must be a letter   Can't end with a hyphen or contain two consecutive hyphens   Example: myoptiongroup .
        engine_name(str): Specifies the name of the engine that this option group should be associated with. Valid Values:     mariadb     mysql     oracle-ee     oracle-ee-cdb     oracle-se2     oracle-se2-cdb     postgres     sqlserver-ee     sqlserver-se     sqlserver-ex     sqlserver-web   .
        major_engine_version(str): Specifies the major version of the engine that this option group should be associated with.
        option_group_description(str): The description of the option group.
        tags(List, optional): Tags to assign to the option group. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.option_group.init.create(
                ctx,
                option_group_name=value,
                engine_name=value,
                major_engine_version=value,
                option_group_description=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.option_group.init.create option_group_name=value, engine_name=value, major_engine_version=value, option_group_description=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="create_option_group",
        op_kwargs={
            "OptionGroupName": option_group_name,
            "EngineName": engine_name,
            "MajorEngineVersion": major_engine_version,
            "OptionGroupDescription": option_group_description,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, option_group_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes an existing option group.

    Args:
        option_group_name(str): The name of the option group to be deleted.  You can't delete default option groups. .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.option_group.init.delete(ctx, option_group_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.option_group.init.delete option_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="delete_option_group",
        op_kwargs={"OptionGroupName": option_group_name},
    )


async def describe_all(
    hub,
    ctx,
    option_group_name: str = None,
    filters: List = None,
    marker: str = None,
    max_records: int = None,
    engine_name: str = None,
    major_engine_version: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the available option groups.

    Args:
        option_group_name(str, optional): The name of the option group to describe. Can't be supplied together with EngineName or MajorEngineVersion. Defaults to None.
        filters(List, optional): This parameter isn't currently supported. Defaults to None.
        marker(str, optional):  An optional pagination token provided by a previous DescribeOptionGroups request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. . Defaults to None.
        max_records(int, optional):  The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.  Default: 100 Constraints: Minimum 20, maximum 100. Defaults to None.
        engine_name(str, optional): Filters the list of option groups to only include groups associated with a specific database engine. Valid Values:     mariadb     mysql     oracle-ee     oracle-ee-cdb     oracle-se2     oracle-se2-cdb     postgres     sqlserver-ee     sqlserver-se     sqlserver-ex     sqlserver-web   . Defaults to None.
        major_engine_version(str, optional): Filters the list of option groups to only include groups associated with a specific database engine version. If specified, then EngineName must also be specified. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.option_group.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.option_group.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="describe_option_groups",
        op_kwargs={
            "OptionGroupName": option_group_name,
            "Filters": filters,
            "Marker": marker,
            "MaxRecords": max_records,
            "EngineName": engine_name,
            "MajorEngineVersion": major_engine_version,
        },
    )


async def modify(
    hub,
    ctx,
    option_group_name: str,
    options_to_include: List = None,
    options_to_remove: List = None,
    apply_immediately: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies an existing option group.

    Args:
        option_group_name(str): The name of the option group to be modified. Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an option group, and that option group can't be removed from a DB instance once it is associated with a DB instance.
        options_to_include(List, optional): Options in this list are added to the option group or, if already present, the specified configuration is used to update the existing configuration. Defaults to None.
        options_to_remove(List, optional): Options in this list are removed from the option group. Defaults to None.
        apply_immediately(bool, optional): A value that indicates whether to apply the change immediately or during the next maintenance window for each instance associated with the option group. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.option_group.init.modify(ctx, option_group_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.option_group.init.modify option_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="modify_option_group",
        op_kwargs={
            "OptionGroupName": option_group_name,
            "OptionsToInclude": options_to_include,
            "OptionsToRemove": options_to_remove,
            "ApplyImmediately": apply_immediately,
        },
    )
