"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"import_": "import"}


async def delete(hub, ctx, installation_media_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the installation medium for a DB engine that requires an on-premises customer provided license, such as Microsoft SQL Server.

    Args:
        installation_media_id(str): The installation medium ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.installation_media.delete(ctx, installation_media_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.installation_media.delete installation_media_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="delete_installation_media",
        op_kwargs={"InstallationMediaId": installation_media_id},
    )


async def describe(
    hub,
    ctx,
    installation_media_id: str = None,
    filters: List = None,
    max_records: int = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the available installation media for a DB engine that requires an on-premises customer provided license, such as Microsoft SQL Server.

    Args:
        installation_media_id(str, optional): The installation medium ID. Defaults to None.
        filters(List, optional): A filter that specifies one or more installation media to describe. Supported filters include the following:    custom-availability-zone-id - Accepts custom Availability Zone (AZ) identifiers. The results list includes information about only the custom AZs identified by these identifiers.    engine - Accepts database engines. The results list includes information about only the database engines identified by these identifiers. For more information about the valid engines for installation media, see ImportInstallationMedia.  . Defaults to None.
        max_records(int, optional): An optional pagination token provided by a previous DescribeInstallationMedia request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. Defaults to None.
        marker(str, optional): An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.installation_media.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.installation_media.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="describe_installation_media",
        op_kwargs={
            "InstallationMediaId": installation_media_id,
            "Filters": filters,
            "MaxRecords": max_records,
            "Marker": marker,
        },
    )


async def import_(
    hub,
    ctx,
    custom_availability_zone_id: str,
    engine: str,
    engine_version: str,
    engine_installation_media_path: str,
    os_installation_media_path: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Imports the installation media for a DB engine that requires an on-premises customer provided license, such as SQL Server.

    Args:
        custom_availability_zone_id(str): The identifier of the custom Availability Zone (AZ) to import the installation media to.
        engine(str): The name of the database engine to be used for this instance.  The list only includes supported DB engines that require an on-premises customer provided license.  Valid Values:     sqlserver-ee     sqlserver-se     sqlserver-ex     sqlserver-web   .
        engine_version(str): The version number of the database engine to use. For a list of valid engine versions, call DescribeDBEngineVersions. The following are the database engines and links to information about the major and minor versions. The list only includes DB engines that require an on-premises customer provided license.  Microsoft SQL Server  See  Microsoft SQL Server Versions on Amazon RDS in the Amazon RDS User Guide. .
        engine_installation_media_path(str): The path to the installation medium for the specified DB engine. Example: SQLServerISO/en_sql_server_2016_enterprise_x64_dvd_8701793.iso .
        os_installation_media_path(str): The path to the installation medium for the operating system associated with the specified DB engine. Example: WindowsISO/en_windows_server_2016_x64_dvd_9327751.iso .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.installation_media.import(ctx, custom_availability_zone_id=value, engine=value, engine_version=value, engine_installation_media_path=value, os_installation_media_path=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.installation_media.import custom_availability_zone_id=value, engine=value, engine_version=value, engine_installation_media_path=value, os_installation_media_path=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="import_installation_media",
        op_kwargs={
            "CustomAvailabilityZoneId": custom_availability_zone_id,
            "Engine": engine,
            "EngineVersion": engine_version,
            "EngineInstallationMediaPath": engine_installation_media_path,
            "OSInstallationMediaPath": os_installation_media_path,
        },
    )
