"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    global_cluster_identifier: str = None,
    source_db_cluster_identifier: str = None,
    engine: str = None,
    engine_version: str = None,
    deletion_protection: bool = None,
    database_name: str = None,
    storage_encrypted: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Creates an Aurora global database spread across multiple Amazon Web Services Regions. The global database contains a single primary cluster with read-write capability, and a read-only secondary cluster that receives data from the primary cluster through high-speed replication performed by the Aurora storage subsystem.   You can create a global database that is initially empty, and then add a primary cluster and a secondary cluster to it. Or you can specify an existing Aurora cluster during the create operation, and this cluster becomes the primary cluster of the global database.   This action only applies to Aurora DB clusters.

    Args:
        global_cluster_identifier(str, optional): The cluster identifier of the new global database cluster. Defaults to None.
        source_db_cluster_identifier(str, optional):  The Amazon Resource Name (ARN) to use as the primary cluster of the global database. This parameter is optional. . Defaults to None.
        engine(str, optional): The name of the database engine to be used for this DB cluster. Defaults to None.
        engine_version(str, optional): The engine version of the Aurora global database. Defaults to None.
        deletion_protection(bool, optional):  The deletion protection setting for the new global database. The global database can't be deleted when deletion protection is enabled. . Defaults to None.
        database_name(str, optional):  The name for your database of up to 64 alpha-numeric characters. If you do not provide a name, Amazon Aurora will not create a database in the global database cluster you are creating. . Defaults to None.
        storage_encrypted(bool, optional):  The storage encryption setting for the new global database cluster. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.global_cluster.create(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.global_cluster.create
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="create_global_cluster",
        op_kwargs={
            "GlobalClusterIdentifier": global_cluster_identifier,
            "SourceDBClusterIdentifier": source_db_cluster_identifier,
            "Engine": engine,
            "EngineVersion": engine_version,
            "DeletionProtection": deletion_protection,
            "DatabaseName": database_name,
            "StorageEncrypted": storage_encrypted,
        },
    )


async def delete(hub, ctx, global_cluster_identifier: str) -> Dict:
    r"""
    **Autogenerated function**

     Deletes a global database cluster. The primary and secondary clusters must already be detached or destroyed first.   This action only applies to Aurora DB clusters.

    Args:
        global_cluster_identifier(str):  The cluster identifier of the global database cluster being deleted. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.global_cluster.delete(ctx, global_cluster_identifier=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.global_cluster.delete global_cluster_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="delete_global_cluster",
        op_kwargs={"GlobalClusterIdentifier": global_cluster_identifier},
    )


async def describe_all(
    hub,
    ctx,
    global_cluster_identifier: str = None,
    filters: List = None,
    max_records: int = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Returns information about Aurora global database clusters. This API supports pagination.   For more information on Amazon Aurora, see  What Is Amazon Aurora? in the Amazon Aurora User Guide.   This action only applies to Aurora DB clusters.

    Args:
        global_cluster_identifier(str, optional):  The user-supplied DB cluster identifier. If this parameter is specified, information from only the specific DB cluster is returned. This parameter isn't case-sensitive.  Constraints:   If supplied, must match an existing DBClusterIdentifier.  . Defaults to None.
        filters(List, optional): This parameter isn't currently supported. Defaults to None.
        max_records(int, optional):  The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.  Default: 100 Constraints: Minimum 20, maximum 100. Defaults to None.
        marker(str, optional):  An optional pagination token provided by a previous DescribeGlobalClusters request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.global_cluster.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.global_cluster.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="describe_global_clusters",
        op_kwargs={
            "GlobalClusterIdentifier": global_cluster_identifier,
            "Filters": filters,
            "MaxRecords": max_records,
            "Marker": marker,
        },
    )


async def failover(
    hub, ctx, global_cluster_identifier: str, target_db_cluster_identifier: str
) -> Dict:
    r"""
    **Autogenerated function**

    Initiates the failover process for an Aurora global database (GlobalCluster). A failover for an Aurora global database promotes one of secondary read-only DB clusters to be the primary DB cluster and demotes the primary DB cluster to being a secondary (read-only) DB cluster. In other words, the role of the current primary DB cluster and the selected (target) DB cluster are switched. The selected secondary DB cluster assumes full read/write capabilities for the Aurora global database. For more information about failing over an Amazon Aurora global database, see Managed planned failover for Amazon Aurora global databases in the Amazon Aurora User Guide.   This action applies to GlobalCluster (Aurora global databases) only. Use this action only on healthy Aurora global databases with running Aurora DB clusters and no Region-wide outages, to test disaster recovery scenarios or to reconfigure your Aurora global database topology.

    Args:
        global_cluster_identifier(str): Identifier of the Aurora global database (GlobalCluster) that should be failed over. The identifier is the unique key assigned by the user when the Aurora global database was created. In other words, it's the name of the Aurora global database that you want to fail over.  Constraints:   Must match the identifier of an existing GlobalCluster (Aurora global database).  .
        target_db_cluster_identifier(str): Identifier of the secondary Aurora DB cluster that you want to promote to primary for the Aurora global database (GlobalCluster.) Use the Amazon Resource Name (ARN) for the identifier so that Aurora can locate the cluster in its Amazon Web Services Region. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.global_cluster.failover(
                ctx, global_cluster_identifier=value, target_db_cluster_identifier=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.global_cluster.failover global_cluster_identifier=value, target_db_cluster_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="failover_global_cluster",
        op_kwargs={
            "GlobalClusterIdentifier": global_cluster_identifier,
            "TargetDbClusterIdentifier": target_db_cluster_identifier,
        },
    )


async def modify(
    hub,
    ctx,
    global_cluster_identifier: str = None,
    new_global_cluster_identifier: str = None,
    deletion_protection: bool = None,
    engine_version: str = None,
    allow_major_version_upgrade: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Modify a setting for an Amazon Aurora global cluster. You can change one or more database configuration parameters by specifying these parameters and the new values in the request. For more information on Amazon Aurora, see  What Is Amazon Aurora? in the Amazon Aurora User Guide.   This action only applies to Aurora DB clusters.

    Args:
        global_cluster_identifier(str, optional):  The DB cluster identifier for the global cluster being modified. This parameter isn't case-sensitive.  Constraints:   Must match the identifier of an existing global database cluster.  . Defaults to None.
        new_global_cluster_identifier(str, optional):  The new cluster identifier for the global database cluster when modifying a global database cluster. This value is stored as a lowercase string.  Constraints:   Must contain from 1 to 63 letters, numbers, or hyphens   The first character must be a letter   Can't end with a hyphen or contain two consecutive hyphens   Example: my-cluster2 . Defaults to None.
        deletion_protection(bool, optional):  Indicates if the global database cluster has deletion protection enabled. The global database cluster can't be deleted when deletion protection is enabled. . Defaults to None.
        engine_version(str, optional): The version number of the database engine to which you want to upgrade. Changing this parameter results in an outage. The change is applied during the next maintenance window unless ApplyImmediately is enabled. To list all of the available engine versions for aurora (for MySQL 5.6-compatible Aurora), use the following command:  aws rds describe-db-engine-versions --engine aurora --query '*[]|[?SupportsGlobalDatabases == `true`].[EngineVersion]'  To list all of the available engine versions for aurora-mysql (for MySQL 5.7-compatible Aurora), use the following command:  aws rds describe-db-engine-versions --engine aurora-mysql --query '*[]|[?SupportsGlobalDatabases == `true`].[EngineVersion]'  To list all of the available engine versions for aurora-postgresql, use the following command:  aws rds describe-db-engine-versions --engine aurora-postgresql --query '*[]|[?SupportsGlobalDatabases == `true`].[EngineVersion]' . Defaults to None.
        allow_major_version_upgrade(bool, optional): A value that indicates whether major version upgrades are allowed. Constraints: You must allow major version upgrades when specifying a value for the EngineVersion parameter that is a different major version than the DB cluster's current version. If you upgrade the major version of a global database, the cluster and DB instance parameter groups are set to the default parameter groups for the new version. Apply any custom parameter groups after completing the upgrade. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.global_cluster.modify(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.global_cluster.modify
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="modify_global_cluster",
        op_kwargs={
            "GlobalClusterIdentifier": global_cluster_identifier,
            "NewGlobalClusterIdentifier": new_global_cluster_identifier,
            "DeletionProtection": deletion_protection,
            "EngineVersion": engine_version,
            "AllowMajorVersionUpgrade": allow_major_version_upgrade,
        },
    )
