"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def remove(
    hub, ctx, global_cluster_identifier: str = None, db_cluster_identifier: str = None
) -> Dict:
    r"""
    **Autogenerated function**

     Detaches an Aurora secondary cluster from an Aurora global database cluster. The cluster becomes a standalone cluster with read-write capability instead of being read-only and receiving data from a primary cluster in a different region.   This action only applies to Aurora DB clusters.

    Args:
        global_cluster_identifier(str, optional):  The cluster identifier to detach from the Aurora global database cluster. . Defaults to None.
        db_cluster_identifier(str, optional):  The Amazon Resource Name (ARN) identifying the cluster that was detached from the Aurora global database cluster. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.from_global_cluster.remove(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.from_global_cluster.remove
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="remove_from_global_cluster",
        op_kwargs={
            "GlobalClusterIdentifier": global_cluster_identifier,
            "DbClusterIdentifier": db_cluster_identifier,
        },
    )
