"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def cancel(hub, ctx, export_task_identifier: str) -> Dict:
    r"""
    **Autogenerated function**

    Cancels an export task in progress that is exporting a snapshot to Amazon S3. Any data that has already been written to the S3 bucket isn't removed.

    Args:
        export_task_identifier(str): The identifier of the snapshot export task to cancel.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.export_task.cancel(ctx, export_task_identifier=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.export_task.cancel export_task_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="cancel_export_task",
        op_kwargs={"ExportTaskIdentifier": export_task_identifier},
    )


async def describe_all(
    hub,
    ctx,
    export_task_identifier: str = None,
    source_arn: str = None,
    filters: List = None,
    marker: str = None,
    max_records: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a snapshot export to Amazon S3. This API operation supports pagination.

    Args:
        export_task_identifier(str, optional): The identifier of the snapshot export task to be described. Defaults to None.
        source_arn(str, optional): The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3. Defaults to None.
        filters(List, optional): Filters specify one or more snapshot exports to describe. The filters are specified as name-value pairs that define what to include in the output. Filter names and values are case-sensitive. Supported filters include the following:     export-task-identifier - An identifier for the snapshot export task.    s3-bucket - The Amazon S3 bucket the snapshot is exported to.    source-arn - The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3    status - The status of the export task. Must be lowercase, for example, complete.  . Defaults to None.
        marker(str, optional):  An optional pagination token provided by a previous DescribeExportTasks request. If you specify this parameter, the response includes only records beyond the marker, up to the value specified by the MaxRecords parameter. . Defaults to None.
        max_records(int, optional):  The maximum number of records to include in the response. If more records exist than the specified value, a pagination token called a marker is included in the response. You can use the marker in a later DescribeExportTasks request to retrieve the remaining results.  Default: 100 Constraints: Minimum 20, maximum 100. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.export_task.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.export_task.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="describe_export_tasks",
        op_kwargs={
            "ExportTaskIdentifier": export_task_identifier,
            "SourceArn": source_arn,
            "Filters": filters,
            "Marker": marker,
            "MaxRecords": max_records,
        },
    )


async def start(
    hub,
    ctx,
    export_task_identifier: str,
    source_arn: str,
    s3_bucket_name: str,
    iam_role_arn: str,
    kms_key_id: str,
    s3_prefix: str = None,
    export_only: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts an export of a snapshot to Amazon S3. The provided IAM role must have access to the S3 bucket.

    Args:
        export_task_identifier(str): A unique identifier for the snapshot export task. This ID isn't an identifier for the Amazon S3 bucket where the snapshot is to be exported to. .
        source_arn(str): The Amazon Resource Name (ARN) of the snapshot to export to Amazon S3.
        s3_bucket_name(str): The name of the Amazon S3 bucket to export the snapshot to.
        iam_role_arn(str): The name of the IAM role to use for writing to the Amazon S3 bucket when exporting a snapshot. .
        kms_key_id(str): The ID of the Amazon Web Services KMS customer master key (CMK) to use to encrypt the snapshot exported to Amazon S3. The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon Web Services KMS customer master key (CMK). The caller of this operation must be authorized to execute the following operations. These can be set in the Amazon Web Services KMS key policy:    GrantOperation.Encrypt   GrantOperation.Decrypt   GrantOperation.GenerateDataKey   GrantOperation.GenerateDataKeyWithoutPlaintext   GrantOperation.ReEncryptFrom   GrantOperation.ReEncryptTo   GrantOperation.CreateGrant   GrantOperation.DescribeKey   GrantOperation.RetireGrant  .
        s3_prefix(str, optional): The Amazon S3 bucket prefix to use as the file name and path of the exported snapshot. Defaults to None.
        export_only(List, optional): The data to be exported from the snapshot. If this parameter is not provided, all the snapshot data is exported. Valid values are the following:    database - Export all the data from a specified database.    database.table table-name - Export a table of the snapshot. This format is valid only for RDS for MySQL, RDS for MariaDB, and Aurora MySQL.    database.schema schema-name - Export a database schema of the snapshot. This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.    database.schema.table table-name - Export a table of the database schema. This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.export_task.start(
                ctx,
                export_task_identifier=value,
                source_arn=value,
                s3_bucket_name=value,
                iam_role_arn=value,
                kms_key_id=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.export_task.start export_task_identifier=value, source_arn=value, s3_bucket_name=value, iam_role_arn=value, kms_key_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="start_export_task",
        op_kwargs={
            "ExportTaskIdentifier": export_task_identifier,
            "SourceArn": source_arn,
            "S3BucketName": s3_bucket_name,
            "IamRoleArn": iam_role_arn,
            "KmsKeyId": kms_key_id,
            "S3Prefix": s3_prefix,
            "ExportOnly": export_only,
        },
    )
