"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def copy(
    hub,
    ctx,
    source_db_snapshot_identifier: str,
    target_db_snapshot_identifier: str,
    kms_key_id: str = None,
    tags: List = None,
    copy_tags: bool = None,
    pre_signed_url: str = None,
    option_group_name: str = None,
    target_custom_availability_zone: str = None,
    source_region: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Copies the specified DB snapshot. The source DB snapshot must be in the available state. You can copy a snapshot from one Amazon Web Services Region to another. In that case, the Amazon Web Services Region where you call the CopyDBSnapshot action is the destination Amazon Web Services Region for the DB snapshot copy.  For more information about copying snapshots, see Copying a DB Snapshot in the Amazon RDS User Guide.

    Args:
        source_db_snapshot_identifier(str): The identifier for the source DB snapshot. If the source snapshot is in the same Amazon Web Services Region as the copy, specify a valid DB snapshot identifier. For example, you might specify rds:mysql-instance1-snapshot-20130805.  If the source snapshot is in a different Amazon Web Services Region than the copy, specify a valid DB snapshot ARN. For example, you might specify arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805.  If you are copying from a shared manual DB snapshot, this parameter must be the Amazon Resource Name (ARN) of the shared DB snapshot.  If you are copying an encrypted snapshot this parameter must be in the ARN format for the source Amazon Web Services Region, and must match the SourceDBSnapshotIdentifier in the PreSignedUrl parameter.  Constraints:   Must specify a valid system snapshot in the "available" state.   Example: rds:mydb-2012-04-02-00-01  Example: arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805 .
        target_db_snapshot_identifier(str): The identifier for the copy of the snapshot.  Constraints:   Can't be null, empty, or blank   Must contain from 1 to 255 letters, numbers, or hyphens   First character must be a letter   Can't end with a hyphen or contain two consecutive hyphens   Example: my-db-snapshot .
        kms_key_id(str, optional): The Amazon Web Services KMS key identifier for an encrypted DB snapshot. The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon Web Services KMS customer master key (CMK).  If you copy an encrypted DB snapshot from your Amazon Web Services account, you can specify a value for this parameter to encrypt the copy with a new Amazon Web Services KMS CMK. If you don't specify a value for this parameter, then the copy of the DB snapshot is encrypted with the same Amazon Web Services KMS key as the source DB snapshot.  If you copy an encrypted DB snapshot that is shared from another Amazon Web Services account, then you must specify a value for this parameter.  If you specify this parameter when you copy an unencrypted snapshot, the copy is encrypted.  If you copy an encrypted snapshot to a different Amazon Web Services Region, then you must specify a Amazon Web Services KMS key identifier for the destination Amazon Web Services Region. Amazon Web Services KMS CMKs are specific to the Amazon Web Services Region that they are created in, and you can't use CMKs from one Amazon Web Services Region in another Amazon Web Services Region. . Defaults to None.
        tags(List, optional): A list of tags. For more information, see Tagging Amazon RDS Resources in the Amazon RDS User Guide. . Defaults to None.
        copy_tags(bool, optional): A value that indicates whether to copy all tags from the source DB snapshot to the target DB snapshot. By default, tags are not copied. Defaults to None.
        pre_signed_url(str, optional): The URL that contains a Signature Version 4 signed request for the CopyDBSnapshot API action in the source Amazon Web Services Region that contains the source DB snapshot to copy.  You must specify this parameter when you copy an encrypted DB snapshot from another Amazon Web Services Region by using the Amazon RDS API. Don't specify PreSignedUrl when you are copying an encrypted DB snapshot in the same Amazon Web Services Region. The presigned URL must be a valid request for the CopyDBSnapshot API action that can be executed in the source Amazon Web Services Region that contains the encrypted DB snapshot to be copied. The presigned URL request must contain the following parameter values:     DestinationRegion - The Amazon Web Services Region that the encrypted DB snapshot is copied to. This Amazon Web Services Region is the same one where the CopyDBSnapshot action is called that contains this presigned URL.  For example, if you copy an encrypted DB snapshot from the us-west-2 Amazon Web Services Region to the us-east-1 Amazon Web Services Region, then you call the CopyDBSnapshot action in the us-east-1 Amazon Web Services Region and provide a presigned URL that contains a call to the CopyDBSnapshot action in the us-west-2 Amazon Web Services Region. For this example, the DestinationRegion in the presigned URL must be set to the us-east-1 Amazon Web Services Region.     KmsKeyId - The Amazon Web Services KMS key identifier for the customer master key (CMK) to use to encrypt the copy of the DB snapshot in the destination Amazon Web Services Region. This is the same identifier for both the CopyDBSnapshot action that is called in the destination Amazon Web Services Region, and the action contained in the presigned URL.     SourceDBSnapshotIdentifier - The DB snapshot identifier for the encrypted snapshot to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you are copying an encrypted DB snapshot from the us-west-2 Amazon Web Services Region, then your SourceDBSnapshotIdentifier looks like the following example: arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20161115.    To learn how to generate a Signature Version 4 signed request, see Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4) and Signature Version 4 Signing Process.   If you are using an Amazon Web Services SDK tool or the CLI, you can specify SourceRegion (or --source-region for the CLI) instead of specifying PreSignedUrl manually. Specifying SourceRegion autogenerates a pre-signed URL that is a valid request for the operation that can be executed in the source Amazon Web Services Region. . Defaults to None.
        option_group_name(str, optional): The name of an option group to associate with the copy of the snapshot. Specify this option if you are copying a snapshot from one Amazon Web Services Region to another, and your DB instance uses a nondefault option group. If your source DB instance uses Transparent Data Encryption for Oracle or Microsoft SQL Server, you must specify this option when copying across Amazon Web Services Regions. For more information, see Option group considerations in the Amazon RDS User Guide. . Defaults to None.
        target_custom_availability_zone(str, optional): The external custom Availability Zone (CAZ) identifier for the target CAZ. Example: rds-caz-aiqhTgQv. Defaults to None.
        source_region(str, optional): The ID of the region that contains the snapshot to be copied. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.snapshot.init.copy(
                ctx, source_db_snapshot_identifier=value, target_db_snapshot_identifier=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.snapshot.init.copy source_db_snapshot_identifier=value, target_db_snapshot_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="copy_db_snapshot",
        op_kwargs={
            "SourceDBSnapshotIdentifier": source_db_snapshot_identifier,
            "TargetDBSnapshotIdentifier": target_db_snapshot_identifier,
            "KmsKeyId": kms_key_id,
            "Tags": tags,
            "CopyTags": copy_tags,
            "PreSignedUrl": pre_signed_url,
            "OptionGroupName": option_group_name,
            "TargetCustomAvailabilityZone": target_custom_availability_zone,
            "SourceRegion": source_region,
        },
    )


async def create(
    hub,
    ctx,
    db_snapshot_identifier: str,
    db_instance_identifier: str,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a snapshot of a DB instance. The source DB instance must be in the available or storage-optimization state.

    Args:
        db_snapshot_identifier(str): The identifier for the DB snapshot. Constraints:   Can't be null, empty, or blank   Must contain from 1 to 255 letters, numbers, or hyphens   First character must be a letter   Can't end with a hyphen or contain two consecutive hyphens   Example: my-snapshot-id .
        db_instance_identifier(str): The identifier of the DB instance that you want to create the snapshot of. Constraints:   Must match the identifier of an existing DBInstance.  .
        tags(List, optional): A list of tags. For more information, see Tagging Amazon RDS Resources in the Amazon RDS User Guide. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.snapshot.init.create(
                ctx, db_snapshot_identifier=value, db_instance_identifier=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.snapshot.init.create db_snapshot_identifier=value, db_instance_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="create_db_snapshot",
        op_kwargs={
            "DBSnapshotIdentifier": db_snapshot_identifier,
            "DBInstanceIdentifier": db_instance_identifier,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, db_snapshot_identifier: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a DB snapshot. If the snapshot is being copied, the copy operation is terminated.  The DB snapshot must be in the available state to be deleted.

    Args:
        db_snapshot_identifier(str): The DB snapshot identifier. Constraints: Must be the name of an existing DB snapshot in the available state.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.snapshot.init.delete(ctx, db_snapshot_identifier=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.snapshot.init.delete db_snapshot_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="delete_db_snapshot",
        op_kwargs={"DBSnapshotIdentifier": db_snapshot_identifier},
    )


async def describe_all(
    hub,
    ctx,
    db_instance_identifier: str = None,
    db_snapshot_identifier: str = None,
    snapshot_type: str = None,
    filters: List = None,
    max_records: int = None,
    marker: str = None,
    include_shared: bool = None,
    include_public: bool = None,
    dbi_resource_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about DB snapshots. This API action supports pagination.

    Args:
        db_instance_identifier(str, optional): The ID of the DB instance to retrieve the list of DB snapshots for. This parameter can't be used in conjunction with DBSnapshotIdentifier. This parameter isn't case-sensitive.  Constraints:   If supplied, must match the identifier of an existing DBInstance.  . Defaults to None.
        db_snapshot_identifier(str, optional):  A specific DB snapshot identifier to describe. This parameter can't be used in conjunction with DBInstanceIdentifier. This value is stored as a lowercase string.  Constraints:   If supplied, must match the identifier of an existing DBSnapshot.   If this identifier is for an automated snapshot, the SnapshotType parameter must also be specified.  . Defaults to None.
        snapshot_type(str, optional): The type of snapshots to be returned. You can specify one of the following values:    automated - Return all DB snapshots that have been automatically taken by Amazon RDS for my Amazon Web Services account.    manual - Return all DB snapshots that have been taken by my Amazon Web Services account.    shared - Return all manual DB snapshots that have been shared to my Amazon Web Services account.    public - Return all DB snapshots that have been marked as public.    awsbackup - Return the DB snapshots managed by the Amazon Web Services Backup service. For information about Amazon Web Services Backup, see the  Amazon Web Services Backup Developer Guide.   The awsbackup type does not apply to Aurora.   If you don't specify a SnapshotType value, then both automated and manual snapshots are returned. Shared and public DB snapshots are not included in the returned results by default. You can include shared snapshots with these results by enabling the IncludeShared parameter. You can include public snapshots with these results by enabling the IncludePublic parameter. The IncludeShared and IncludePublic parameters don't apply for SnapshotType values of manual or automated. The IncludePublic parameter doesn't apply when SnapshotType is set to shared. The IncludeShared parameter doesn't apply when SnapshotType is set to public. Defaults to None.
        filters(List, optional): A filter that specifies one or more DB snapshots to describe. Supported filters:    db-instance-id - Accepts DB instance identifiers and DB instance Amazon Resource Names (ARNs).    db-snapshot-id - Accepts DB snapshot identifiers.    dbi-resource-id - Accepts identifiers of source DB instances.    snapshot-type - Accepts types of DB snapshots.    engine - Accepts names of database engines.  . Defaults to None.
        max_records(int, optional):  The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.  Default: 100 Constraints: Minimum 20, maximum 100. Defaults to None.
        marker(str, optional):  An optional pagination token provided by a previous DescribeDBSnapshots request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. . Defaults to None.
        include_shared(bool, optional): A value that indicates whether to include shared manual DB cluster snapshots from other Amazon Web Services accounts that this Amazon Web Services account has been given permission to copy or restore. By default, these snapshots are not included. You can give an Amazon Web Services account permission to restore a manual DB snapshot from another Amazon Web Services account by using the ModifyDBSnapshotAttribute API action. Defaults to None.
        include_public(bool, optional): A value that indicates whether to include manual DB cluster snapshots that are public and can be copied or restored by any Amazon Web Services account. By default, the public snapshots are not included. You can share a manual DB snapshot as public by using the ModifyDBSnapshotAttribute API. Defaults to None.
        dbi_resource_id(str, optional): A specific DB resource ID to describe. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.snapshot.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.snapshot.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="describe_db_snapshots",
        op_kwargs={
            "DBInstanceIdentifier": db_instance_identifier,
            "DBSnapshotIdentifier": db_snapshot_identifier,
            "SnapshotType": snapshot_type,
            "Filters": filters,
            "MaxRecords": max_records,
            "Marker": marker,
            "IncludeShared": include_shared,
            "IncludePublic": include_public,
            "DbiResourceId": dbi_resource_id,
        },
    )


async def modify(
    hub,
    ctx,
    db_snapshot_identifier: str,
    engine_version: str = None,
    option_group_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a manual DB snapshot with a new engine version. The snapshot can be encrypted or unencrypted, but not shared or public.  Amazon RDS supports upgrading DB snapshots for MySQL, Oracle, and PostgreSQL.

    Args:
        db_snapshot_identifier(str): The identifier of the DB snapshot to modify.
        engine_version(str, optional): The engine version to upgrade the DB snapshot to.  The following are the database engines and engine versions that are available when you upgrade a DB snapshot.   MySQL     5.5.46 (supported for 5.1 DB snapshots)    Oracle     12.1.0.2.v8 (supported for 12.1.0.1 DB snapshots)    11.2.0.4.v12 (supported for 11.2.0.2 DB snapshots)    11.2.0.4.v11 (supported for 11.2.0.3 DB snapshots)    PostgreSQL  For the list of engine versions that are available for upgrading a DB snapshot, see  Upgrading the PostgreSQL DB Engine for Amazon RDS. . Defaults to None.
        option_group_name(str, optional): The option group to identify with the upgraded DB snapshot.  You can specify this parameter when you upgrade an Oracle DB snapshot. The same option group considerations apply when upgrading a DB snapshot as when upgrading a DB instance. For more information, see Option group considerations in the Amazon RDS User Guide. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.snapshot.init.modify(ctx, db_snapshot_identifier=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.snapshot.init.modify db_snapshot_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="modify_db_snapshot",
        op_kwargs={
            "DBSnapshotIdentifier": db_snapshot_identifier,
            "EngineVersion": engine_version,
            "OptionGroupName": option_group_name,
        },
    )
