"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    db_security_group_name: str,
    db_security_group_description: str,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new DB security group. DB security groups control access to a DB instance.  A DB security group controls access to EC2-Classic DB instances that are not in a VPC.

    Args:
        db_security_group_name(str): The name for the DB security group. This value is stored as a lowercase string. Constraints:   Must be 1 to 255 letters, numbers, or hyphens.   First character must be a letter   Can't end with a hyphen or contain two consecutive hyphens   Must not be "Default"   Example: mysecuritygroup .
        db_security_group_description(str): The description for the DB security group.
        tags(List, optional): Tags to assign to the DB security group. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.security_group.init.create(
                ctx, db_security_group_name=value, db_security_group_description=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.security_group.init.create db_security_group_name=value, db_security_group_description=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="create_db_security_group",
        op_kwargs={
            "DBSecurityGroupName": db_security_group_name,
            "DBSecurityGroupDescription": db_security_group_description,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, db_security_group_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a DB security group.  The specified DB security group must not be associated with any DB instances.

    Args:
        db_security_group_name(str): The name of the DB security group to delete.  You can't delete the default DB security group.  Constraints:   Must be 1 to 255 letters, numbers, or hyphens.   First character must be a letter   Can't end with a hyphen or contain two consecutive hyphens   Must not be "Default"  .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.security_group.init.delete(
                ctx, db_security_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.security_group.init.delete db_security_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="delete_db_security_group",
        op_kwargs={"DBSecurityGroupName": db_security_group_name},
    )


async def describe_all(
    hub,
    ctx,
    db_security_group_name: str = None,
    filters: List = None,
    max_records: int = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Returns a list of DBSecurityGroup descriptions. If a DBSecurityGroupName is specified, the list will contain only the descriptions of the specified DB security group.

    Args:
        db_security_group_name(str, optional): The name of the DB security group to return details for. Defaults to None.
        filters(List, optional): This parameter isn't currently supported. Defaults to None.
        max_records(int, optional):  The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.  Default: 100 Constraints: Minimum 20, maximum 100. Defaults to None.
        marker(str, optional):  An optional pagination token provided by a previous DescribeDBSecurityGroups request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.security_group.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.security_group.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="describe_db_security_groups",
        op_kwargs={
            "DBSecurityGroupName": db_security_group_name,
            "Filters": filters,
            "MaxRecords": max_records,
            "Marker": marker,
        },
    )
