"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def authorize(
    hub,
    ctx,
    db_security_group_name: str,
    cidrip: str = None,
    ec2_security_group_name: str = None,
    ec2_security_group_id: str = None,
    ec2_security_group_owner_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Enables ingress to a DBSecurityGroup using one of two forms of authorization. First, EC2 or VPC security groups can be added to the DBSecurityGroup if the application using the database is running on EC2 or VPC instances. Second, IP ranges are available if the application accessing your database is running on the Internet. Required parameters for this API are one of CIDR range, EC2SecurityGroupId for VPC, or (EC2SecurityGroupOwnerId and either EC2SecurityGroupName or EC2SecurityGroupId for non-VPC).  You can't authorize ingress from an EC2 security group in one Amazon Web Services Region to an Amazon RDS DB instance in another. You can't authorize ingress from a VPC security group in one VPC to an Amazon RDS DB instance in another.  For an overview of CIDR ranges, go to the Wikipedia Tutorial.

    Args:
        db_security_group_name(str): The name of the DB security group to add authorization to.
        cidrip(str, optional): The IP range to authorize. Defaults to None.
        ec2_security_group_name(str, optional):  Name of the EC2 security group to authorize. For VPC DB security groups, EC2SecurityGroupId must be provided. Otherwise, EC2SecurityGroupOwnerId and either EC2SecurityGroupName or EC2SecurityGroupId must be provided. . Defaults to None.
        ec2_security_group_id(str, optional):  Id of the EC2 security group to authorize. For VPC DB security groups, EC2SecurityGroupId must be provided. Otherwise, EC2SecurityGroupOwnerId and either EC2SecurityGroupName or EC2SecurityGroupId must be provided. . Defaults to None.
        ec2_security_group_owner_id(str, optional):  Amazon Web Services account number of the owner of the EC2 security group specified in the EC2SecurityGroupName parameter. The Amazon Web Services access key ID isn't an acceptable value. For VPC DB security groups, EC2SecurityGroupId must be provided. Otherwise, EC2SecurityGroupOwnerId and either EC2SecurityGroupName or EC2SecurityGroupId must be provided. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.security_group.ingress.authorize(
                ctx, db_security_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.security_group.ingress.authorize db_security_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="authorize_db_security_group_ingress",
        op_kwargs={
            "DBSecurityGroupName": db_security_group_name,
            "CIDRIP": cidrip,
            "EC2SecurityGroupName": ec2_security_group_name,
            "EC2SecurityGroupId": ec2_security_group_id,
            "EC2SecurityGroupOwnerId": ec2_security_group_owner_id,
        },
    )


async def revoke(
    hub,
    ctx,
    db_security_group_name: str,
    cidrip: str = None,
    ec2_security_group_name: str = None,
    ec2_security_group_id: str = None,
    ec2_security_group_owner_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Revokes ingress from a DBSecurityGroup for previously authorized IP ranges or EC2 or VPC security groups. Required parameters for this API are one of CIDRIP, EC2SecurityGroupId for VPC, or (EC2SecurityGroupOwnerId and either EC2SecurityGroupName or EC2SecurityGroupId).

    Args:
        db_security_group_name(str): The name of the DB security group to revoke ingress from.
        cidrip(str, optional):  The IP range to revoke access from. Must be a valid CIDR range. If CIDRIP is specified, EC2SecurityGroupName, EC2SecurityGroupId and EC2SecurityGroupOwnerId can't be provided. . Defaults to None.
        ec2_security_group_name(str, optional):  The name of the EC2 security group to revoke access from. For VPC DB security groups, EC2SecurityGroupId must be provided. Otherwise, EC2SecurityGroupOwnerId and either EC2SecurityGroupName or EC2SecurityGroupId must be provided. . Defaults to None.
        ec2_security_group_id(str, optional):  The id of the EC2 security group to revoke access from. For VPC DB security groups, EC2SecurityGroupId must be provided. Otherwise, EC2SecurityGroupOwnerId and either EC2SecurityGroupName or EC2SecurityGroupId must be provided. . Defaults to None.
        ec2_security_group_owner_id(str, optional):  The Amazon Web Services account number of the owner of the EC2 security group specified in the EC2SecurityGroupName parameter. The Amazon Web Services access key ID isn't an acceptable value. For VPC DB security groups, EC2SecurityGroupId must be provided. Otherwise, EC2SecurityGroupOwnerId and either EC2SecurityGroupName or EC2SecurityGroupId must be provided. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.security_group.ingress.revoke(
                ctx, db_security_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.security_group.ingress.revoke db_security_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="revoke_db_security_group_ingress",
        op_kwargs={
            "DBSecurityGroupName": db_security_group_name,
            "CIDRIP": cidrip,
            "EC2SecurityGroupName": ec2_security_group_name,
            "EC2SecurityGroupId": ec2_security_group_id,
            "EC2SecurityGroupOwnerId": ec2_security_group_owner_id,
        },
    )
