"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def deregister(
    hub,
    ctx,
    db_proxy_name: str,
    target_group_name: str = None,
    db_instance_identifiers: List = None,
    db_cluster_identifiers: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Remove the association between one or more DBProxyTarget data structures and a DBProxyTargetGroup.

    Args:
        db_proxy_name(str): The identifier of the DBProxy that is associated with the DBProxyTargetGroup.
        target_group_name(str, optional): The identifier of the DBProxyTargetGroup. Defaults to None.
        db_instance_identifiers(List, optional): One or more DB instance identifiers. Defaults to None.
        db_cluster_identifiers(List, optional): One or more DB cluster identifiers. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.proxy.target.init.deregister(ctx, db_proxy_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.proxy.target.init.deregister db_proxy_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="deregister_db_proxy_targets",
        op_kwargs={
            "DBProxyName": db_proxy_name,
            "TargetGroupName": target_group_name,
            "DBInstanceIdentifiers": db_instance_identifiers,
            "DBClusterIdentifiers": db_cluster_identifiers,
        },
    )


async def describe_all(
    hub,
    ctx,
    db_proxy_name: str,
    target_group_name: str = None,
    filters: List = None,
    marker: str = None,
    max_records: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about DBProxyTarget objects. This API supports pagination.

    Args:
        db_proxy_name(str): The identifier of the DBProxyTarget to describe.
        target_group_name(str, optional): The identifier of the DBProxyTargetGroup to describe. Defaults to None.
        filters(List, optional): This parameter is not currently supported. Defaults to None.
        marker(str, optional):  An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. . Defaults to None.
        max_records(int, optional):  The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.  Default: 100 Constraints: Minimum 20, maximum 100. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.proxy.target.init.describe_all(ctx, db_proxy_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.proxy.target.init.describe_all db_proxy_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="describe_db_proxy_targets",
        op_kwargs={
            "DBProxyName": db_proxy_name,
            "TargetGroupName": target_group_name,
            "Filters": filters,
            "Marker": marker,
            "MaxRecords": max_records,
        },
    )


async def register(
    hub,
    ctx,
    db_proxy_name: str,
    target_group_name: str = None,
    db_instance_identifiers: List = None,
    db_cluster_identifiers: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Associate one or more DBProxyTarget data structures with a DBProxyTargetGroup.

    Args:
        db_proxy_name(str): The identifier of the DBProxy that is associated with the DBProxyTargetGroup.
        target_group_name(str, optional): The identifier of the DBProxyTargetGroup. Defaults to None.
        db_instance_identifiers(List, optional): One or more DB instance identifiers. Defaults to None.
        db_cluster_identifiers(List, optional): One or more DB cluster identifiers. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.proxy.target.init.register(ctx, db_proxy_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.proxy.target.init.register db_proxy_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="register_db_proxy_targets",
        op_kwargs={
            "DBProxyName": db_proxy_name,
            "TargetGroupName": target_group_name,
            "DBInstanceIdentifiers": db_instance_identifiers,
            "DBClusterIdentifiers": db_cluster_identifiers,
        },
    )
