"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    db_proxy_name: str,
    target_group_name: str = None,
    filters: List = None,
    marker: str = None,
    max_records: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about DB proxy target groups, represented by DBProxyTargetGroup data structures.

    Args:
        db_proxy_name(str): The identifier of the DBProxy associated with the target group.
        target_group_name(str, optional): The identifier of the DBProxyTargetGroup to describe. Defaults to None.
        filters(List, optional): This parameter is not currently supported. Defaults to None.
        marker(str, optional):  An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. . Defaults to None.
        max_records(int, optional):  The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.  Default: 100 Constraints: Minimum 20, maximum 100. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.proxy.target.group.describe_all(ctx, db_proxy_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.proxy.target.group.describe_all db_proxy_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="describe_db_proxy_target_groups",
        op_kwargs={
            "DBProxyName": db_proxy_name,
            "TargetGroupName": target_group_name,
            "Filters": filters,
            "Marker": marker,
            "MaxRecords": max_records,
        },
    )


async def modify(
    hub,
    ctx,
    target_group_name: str,
    db_proxy_name: str,
    connection_pool_config: Dict = None,
    new_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the properties of a DBProxyTargetGroup.

    Args:
        target_group_name(str): The name of the new target group to assign to the proxy.
        db_proxy_name(str): The name of the new proxy to which to assign the target group.
        connection_pool_config(Dict, optional): The settings that determine the size and behavior of the connection pool for the target group. Defaults to None.
        new_name(str, optional): The new name for the modified DBProxyTarget. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.proxy.target.group.modify(
                ctx, target_group_name=value, db_proxy_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.proxy.target.group.modify target_group_name=value, db_proxy_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="modify_db_proxy_target_group",
        op_kwargs={
            "TargetGroupName": target_group_name,
            "DBProxyName": db_proxy_name,
            "ConnectionPoolConfig": connection_pool_config,
            "NewName": new_name,
        },
    )
