"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    db_proxy_name: str,
    engine_family: str,
    auth: List,
    role_arn: str,
    vpc_subnet_ids: List,
    vpc_security_group_ids: List = None,
    require_tls: bool = None,
    idle_client_timeout: int = None,
    debug_logging: bool = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new DB proxy.

    Args:
        db_proxy_name(str): The identifier for the proxy. This name must be unique for all proxies owned by your Amazon Web Services account in the specified Amazon Web Services Region. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.
        engine_family(str): The kinds of databases that the proxy can connect to. This value determines which database network protocol the proxy recognizes when it interprets network traffic to and from the database. The engine family applies to MySQL and PostgreSQL for both RDS and Aurora.
        auth(List): The authorization mechanism that the proxy uses.
        role_arn(str): The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access secrets in Amazon Web Services Secrets Manager.
        vpc_subnet_ids(List): One or more VPC subnet IDs to associate with the new proxy.
        vpc_security_group_ids(List, optional): One or more VPC security group IDs to associate with the new proxy. Defaults to None.
        require_tls(bool, optional): A Boolean parameter that specifies whether Transport Layer Security (TLS) encryption is required for connections to the proxy. By enabling this setting, you can enforce encrypted TLS connections to the proxy. Defaults to None.
        idle_client_timeout(int, optional): The number of seconds that a connection to the proxy can be inactive before the proxy disconnects it. You can set this value higher or lower than the connection timeout limit for the associated database. Defaults to None.
        debug_logging(bool, optional): Whether the proxy includes detailed information about SQL statements in its logs. This information helps you to debug issues involving SQL behavior or the performance and scalability of the proxy connections. The debug information includes the text of SQL statements that you submit through the proxy. Thus, only enable this setting when needed for debugging, and only when you have security measures in place to safeguard any sensitive information that appears in the logs. Defaults to None.
        tags(List, optional): An optional set of key-value pairs to associate arbitrary data of your choosing with the proxy. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.proxy.init.create(
                ctx,
                db_proxy_name=value,
                engine_family=value,
                auth=value,
                role_arn=value,
                vpc_subnet_ids=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.proxy.init.create db_proxy_name=value, engine_family=value, auth=value, role_arn=value, vpc_subnet_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="create_db_proxy",
        op_kwargs={
            "DBProxyName": db_proxy_name,
            "EngineFamily": engine_family,
            "Auth": auth,
            "RoleArn": role_arn,
            "VpcSubnetIds": vpc_subnet_ids,
            "VpcSecurityGroupIds": vpc_security_group_ids,
            "RequireTLS": require_tls,
            "IdleClientTimeout": idle_client_timeout,
            "DebugLogging": debug_logging,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, db_proxy_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an existing DB proxy.

    Args:
        db_proxy_name(str): The name of the DB proxy to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.proxy.init.delete(ctx, db_proxy_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.proxy.init.delete db_proxy_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="delete_db_proxy",
        op_kwargs={"DBProxyName": db_proxy_name},
    )


async def describe_all(
    hub,
    ctx,
    db_proxy_name: str = None,
    filters: List = None,
    marker: str = None,
    max_records: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about DB proxies.

    Args:
        db_proxy_name(str, optional): The name of the DB proxy. If you omit this parameter, the output includes information about all DB proxies owned by your Amazon Web Services account ID. Defaults to None.
        filters(List, optional): This parameter is not currently supported. Defaults to None.
        marker(str, optional):  An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. . Defaults to None.
        max_records(int, optional): The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.  Default: 100 Constraints: Minimum 20, maximum 100. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.proxy.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.proxy.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="describe_db_proxies",
        op_kwargs={
            "DBProxyName": db_proxy_name,
            "Filters": filters,
            "Marker": marker,
            "MaxRecords": max_records,
        },
    )


async def modify(
    hub,
    ctx,
    db_proxy_name: str,
    new_db_proxy_name: str = None,
    auth: List = None,
    require_tls: bool = None,
    idle_client_timeout: int = None,
    debug_logging: bool = None,
    role_arn: str = None,
    security_groups: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Changes the settings for an existing DB proxy.

    Args:
        db_proxy_name(str): The identifier for the DBProxy to modify.
        new_db_proxy_name(str, optional): The new identifier for the DBProxy. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens. Defaults to None.
        auth(List, optional): The new authentication settings for the DBProxy. Defaults to None.
        require_tls(bool, optional): Whether Transport Layer Security (TLS) encryption is required for connections to the proxy. By enabling this setting, you can enforce encrypted TLS connections to the proxy, even if the associated database doesn't use TLS. Defaults to None.
        idle_client_timeout(int, optional): The number of seconds that a connection to the proxy can be inactive before the proxy disconnects it. You can set this value higher or lower than the connection timeout limit for the associated database. Defaults to None.
        debug_logging(bool, optional): Whether the proxy includes detailed information about SQL statements in its logs. This information helps you to debug issues involving SQL behavior or the performance and scalability of the proxy connections. The debug information includes the text of SQL statements that you submit through the proxy. Thus, only enable this setting when needed for debugging, and only when you have security measures in place to safeguard any sensitive information that appears in the logs. Defaults to None.
        role_arn(str, optional): The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access secrets in Amazon Web Services Secrets Manager. Defaults to None.
        security_groups(List, optional): The new list of security groups for the DBProxy. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.proxy.init.modify(ctx, db_proxy_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.proxy.init.modify db_proxy_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="modify_db_proxy",
        op_kwargs={
            "DBProxyName": db_proxy_name,
            "NewDBProxyName": new_db_proxy_name,
            "Auth": auth,
            "RequireTLS": require_tls,
            "IdleClientTimeout": idle_client_timeout,
            "DebugLogging": debug_logging,
            "RoleArn": role_arn,
            "SecurityGroups": security_groups,
        },
    )
