"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    db_proxy_name: str,
    db_proxy_endpoint_name: str,
    vpc_subnet_ids: List,
    vpc_security_group_ids: List = None,
    target_role: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Creates a DBProxyEndpoint. Only applies to proxies that are associated with Aurora DB clusters. You can use DB proxy endpoints to specify read/write or read-only access to the DB cluster. You can also use DB proxy endpoints to access a DB proxy through a different VPC than the proxy's default VPC.

    Args:
        db_proxy_name(str): The name of the DB proxy associated with the DB proxy endpoint that you create.
        db_proxy_endpoint_name(str): The name of the DB proxy endpoint to create.
        vpc_subnet_ids(List): The VPC subnet IDs for the DB proxy endpoint that you create. You can specify a different set of subnet IDs than for the original DB proxy.
        vpc_security_group_ids(List, optional): The VPC security group IDs for the DB proxy endpoint that you create. You can specify a different set of security group IDs than for the original DB proxy. The default is the default security group for the VPC. Defaults to None.
        target_role(str, optional): A value that indicates whether the DB proxy endpoint can be used for read/write or read-only operations. The default is READ_WRITE. Defaults to None.
        tags(List, optional): A list of tags. For more information, see Tagging Amazon RDS Resources in the Amazon RDS User Guide. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.proxy.endpoint.create(
                ctx, db_proxy_name=value, db_proxy_endpoint_name=value, vpc_subnet_ids=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.proxy.endpoint.create db_proxy_name=value, db_proxy_endpoint_name=value, vpc_subnet_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="create_db_proxy_endpoint",
        op_kwargs={
            "DBProxyName": db_proxy_name,
            "DBProxyEndpointName": db_proxy_endpoint_name,
            "VpcSubnetIds": vpc_subnet_ids,
            "VpcSecurityGroupIds": vpc_security_group_ids,
            "TargetRole": target_role,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, db_proxy_endpoint_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a DBProxyEndpoint. Doing so removes the ability to access the DB proxy using the endpoint that you defined. The endpoint that you delete might have provided capabilities such as read/write or read-only operations, or using a different VPC than the DB proxy's default VPC.

    Args:
        db_proxy_endpoint_name(str): The name of the DB proxy endpoint to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.proxy.endpoint.delete(ctx, db_proxy_endpoint_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.proxy.endpoint.delete db_proxy_endpoint_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="delete_db_proxy_endpoint",
        op_kwargs={"DBProxyEndpointName": db_proxy_endpoint_name},
    )


async def describe_all(
    hub,
    ctx,
    db_proxy_name: str = None,
    db_proxy_endpoint_name: str = None,
    filters: List = None,
    marker: str = None,
    max_records: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about DB proxy endpoints.

    Args:
        db_proxy_name(str, optional): The name of the DB proxy whose endpoints you want to describe. If you omit this parameter, the output includes information about all DB proxy endpoints associated with all your DB proxies. Defaults to None.
        db_proxy_endpoint_name(str, optional): The name of a DB proxy endpoint to describe. If you omit this parameter, the output includes information about all DB proxy endpoints associated with the specified proxy. Defaults to None.
        filters(List, optional): This parameter is not currently supported. Defaults to None.
        marker(str, optional):  An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. . Defaults to None.
        max_records(int, optional): The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.  Default: 100 Constraints: Minimum 20, maximum 100. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.proxy.endpoint.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.proxy.endpoint.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="describe_db_proxy_endpoints",
        op_kwargs={
            "DBProxyName": db_proxy_name,
            "DBProxyEndpointName": db_proxy_endpoint_name,
            "Filters": filters,
            "Marker": marker,
            "MaxRecords": max_records,
        },
    )


async def modify(
    hub,
    ctx,
    db_proxy_endpoint_name: str,
    new_db_proxy_endpoint_name: str = None,
    vpc_security_group_ids: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Changes the settings for an existing DB proxy endpoint.

    Args:
        db_proxy_endpoint_name(str): The name of the DB proxy sociated with the DB proxy endpoint that you want to modify.
        new_db_proxy_endpoint_name(str, optional): The new identifier for the DBProxyEndpoint. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens. Defaults to None.
        vpc_security_group_ids(List, optional): The VPC security group IDs for the DB proxy endpoint. When the DB proxy endpoint uses a different VPC than the original proxy, you also specify a different set of security group IDs than for the original proxy. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.proxy.endpoint.modify(ctx, db_proxy_endpoint_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.proxy.endpoint.modify db_proxy_endpoint_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="modify_db_proxy_endpoint",
        op_kwargs={
            "DBProxyEndpointName": db_proxy_endpoint_name,
            "NewDBProxyEndpointName": new_db_proxy_endpoint_name,
            "VpcSecurityGroupIds": vpc_security_group_ids,
        },
    )
