"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def copy(
    hub,
    ctx,
    source_db_parameter_group_identifier: str,
    target_db_parameter_group_identifier: str,
    target_db_parameter_group_description: str,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Copies the specified DB parameter group.

    Args:
        source_db_parameter_group_identifier(str):  The identifier or ARN for the source DB parameter group. For information about creating an ARN, see  Constructing an ARN for Amazon RDS in the Amazon RDS User Guide.  Constraints:   Must specify a valid DB parameter group.  .
        target_db_parameter_group_identifier(str): The identifier for the copied DB parameter group. Constraints:   Can't be null, empty, or blank   Must contain from 1 to 255 letters, numbers, or hyphens   First character must be a letter   Can't end with a hyphen or contain two consecutive hyphens   Example: my-db-parameter-group .
        target_db_parameter_group_description(str): A description for the copied DB parameter group.
        tags(List, optional): A list of tags. For more information, see Tagging Amazon RDS Resources in the Amazon RDS User Guide. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.parameter.group.copy(
                ctx,
                source_db_parameter_group_identifier=value,
                target_db_parameter_group_identifier=value,
                target_db_parameter_group_description=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.parameter.group.copy source_db_parameter_group_identifier=value, target_db_parameter_group_identifier=value, target_db_parameter_group_description=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="copy_db_parameter_group",
        op_kwargs={
            "SourceDBParameterGroupIdentifier": source_db_parameter_group_identifier,
            "TargetDBParameterGroupIdentifier": target_db_parameter_group_identifier,
            "TargetDBParameterGroupDescription": target_db_parameter_group_description,
            "Tags": tags,
        },
    )


async def create(
    hub,
    ctx,
    db_parameter_group_name: str,
    db_parameter_group_family: str,
    description: str,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new DB parameter group.  A DB parameter group is initially created with the default parameters for the database engine used by the DB instance. To provide custom values for any of the parameters, you must modify the group after creating it using ModifyDBParameterGroup. Once you've created a DB parameter group, you need to associate it with your DB instance using ModifyDBInstance. When you associate a new DB parameter group with a running DB instance, you need to reboot the DB instance without failover for the new DB parameter group and associated settings to take effect.   After you create a DB parameter group, you should wait at least 5 minutes before creating your first DB instance that uses that DB parameter group as the default parameter group. This allows Amazon RDS to fully complete the create action before the parameter group is used as the default for a new DB instance. This is especially important for parameters that are critical when creating the default database for a DB instance, such as the character set for the default database defined by the character_set_database parameter. You can use the Parameter Groups option of the Amazon RDS console or the DescribeDBParameters command to verify that your DB parameter group has been created or modified.

    Args:
        db_parameter_group_name(str): The name of the DB parameter group. Constraints:   Must be 1 to 255 letters, numbers, or hyphens.   First character must be a letter   Can't end with a hyphen or contain two consecutive hyphens    This value is stored as a lowercase string. .
        db_parameter_group_family(str): The DB parameter group family name. A DB parameter group can be associated with one and only one DB parameter group family, and can be applied only to a DB instance running a database engine and engine version compatible with that DB parameter group family. To list all of the available parameter group families for a DB engine, use the following command:  aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine <engine>  For example, to list all of the available parameter group families for the MySQL DB engine, use the following command:  aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine mysql   The output contains duplicates.  The following are the valid DB engine values:    aurora (for MySQL 5.6-compatible Aurora)    aurora-mysql (for MySQL 5.7-compatible Aurora)    aurora-postgresql     mariadb     mysql     oracle-ee     oracle-ee-cdb     oracle-se2     oracle-se2-cdb     postgres     sqlserver-ee     sqlserver-se     sqlserver-ex     sqlserver-web   .
        description(str): The description for the DB parameter group.
        tags(List, optional): Tags to assign to the DB parameter group. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.parameter.group.create(
                ctx,
                db_parameter_group_name=value,
                db_parameter_group_family=value,
                description=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.parameter.group.create db_parameter_group_name=value, db_parameter_group_family=value, description=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="create_db_parameter_group",
        op_kwargs={
            "DBParameterGroupName": db_parameter_group_name,
            "DBParameterGroupFamily": db_parameter_group_family,
            "Description": description,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, db_parameter_group_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a specified DB parameter group. The DB parameter group to be deleted can't be associated with any DB instances.

    Args:
        db_parameter_group_name(str): The name of the DB parameter group. Constraints:   Must be the name of an existing DB parameter group   You can't delete a default DB parameter group   Can't be associated with any DB instances  .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.parameter.group.delete(
                ctx, db_parameter_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.parameter.group.delete db_parameter_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="delete_db_parameter_group",
        op_kwargs={"DBParameterGroupName": db_parameter_group_name},
    )


async def describe_all(
    hub,
    ctx,
    db_parameter_group_name: str = None,
    filters: List = None,
    max_records: int = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Returns a list of DBParameterGroup descriptions. If a DBParameterGroupName is specified, the list will contain only the description of the specified DB parameter group.

    Args:
        db_parameter_group_name(str, optional): The name of a specific DB parameter group to return details for. Constraints:   If supplied, must match the name of an existing DBClusterParameterGroup.  . Defaults to None.
        filters(List, optional): This parameter isn't currently supported. Defaults to None.
        max_records(int, optional):  The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.  Default: 100 Constraints: Minimum 20, maximum 100. Defaults to None.
        marker(str, optional):  An optional pagination token provided by a previous DescribeDBParameterGroups request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.parameter.group.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.parameter.group.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="describe_db_parameter_groups",
        op_kwargs={
            "DBParameterGroupName": db_parameter_group_name,
            "Filters": filters,
            "MaxRecords": max_records,
            "Marker": marker,
        },
    )


async def modify(hub, ctx, db_parameter_group_name: str, parameters: List) -> Dict:
    r"""
    **Autogenerated function**

     Modifies the parameters of a DB parameter group. To modify more than one parameter, submit a list of the following: ParameterName, ParameterValue, and ApplyMethod. A maximum of 20 parameters can be modified in a single request.   After you modify a DB parameter group, you should wait at least 5 minutes before creating your first DB instance that uses that DB parameter group as the default parameter group. This allows Amazon RDS to fully complete the modify action before the parameter group is used as the default for a new DB instance. This is especially important for parameters that are critical when creating the default database for a DB instance, such as the character set for the default database defined by the character_set_database parameter. You can use the Parameter Groups option of the Amazon RDS console or the DescribeDBParameters command to verify that your DB parameter group has been created or modified.

    Args:
        db_parameter_group_name(str): The name of the DB parameter group. Constraints:   If supplied, must match the name of an existing DBParameterGroup.  .
        parameters(List): An array of parameter names, values, and the application methods for the parameter update. At least one parameter name, value, and application method method must be supplied; later arguments are optional. A maximum of 20 parameters can be modified in a single request. Valid Values (for the application method): immediate | pending-reboot   You can use the immediate value with dynamic parameters only. You can use the pending-reboot value for both dynamic and static parameters. When the application method is immediate, changes to dynamic parameters are applied immediately to the DB instances associated with the parameter group. When the application method is pending-reboot, changes to dynamic and static parameters are applied after a reboot without failover to the DB instances associated with the parameter group. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.parameter.group.modify(
                ctx, db_parameter_group_name=value, parameters=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.parameter.group.modify db_parameter_group_name=value, parameters=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="modify_db_parameter_group",
        op_kwargs={
            "DBParameterGroupName": db_parameter_group_name,
            "Parameters": parameters,
        },
    )


async def reset(
    hub,
    ctx,
    db_parameter_group_name: str,
    reset_all_parameters: bool = None,
    parameters: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the parameters of a DB parameter group to the engine/system default value. To reset specific parameters, provide a list of the following: ParameterName and ApplyMethod. To reset the entire DB parameter group, specify the DBParameterGroup name and ResetAllParameters parameters. When resetting the entire group, dynamic parameters are updated immediately and static parameters are set to pending-reboot to take effect on the next DB instance restart or RebootDBInstance request.

    Args:
        db_parameter_group_name(str): The name of the DB parameter group. Constraints:   Must match the name of an existing DBParameterGroup.  .
        reset_all_parameters(bool, optional):  A value that indicates whether to reset all parameters in the DB parameter group to default values. By default, all parameters in the DB parameter group are reset to default values. . Defaults to None.
        parameters(List, optional): To reset the entire DB parameter group, specify the DBParameterGroup name and ResetAllParameters parameters. To reset specific parameters, provide a list of the following: ParameterName and ApplyMethod. A maximum of 20 parameters can be modified in a single request.  MySQL  Valid Values (for Apply method): immediate | pending-reboot  You can use the immediate value with dynamic parameters only. You can use the pending-reboot value for both dynamic and static parameters, and changes are applied when DB instance reboots.  MariaDB  Valid Values (for Apply method): immediate | pending-reboot  You can use the immediate value with dynamic parameters only. You can use the pending-reboot value for both dynamic and static parameters, and changes are applied when DB instance reboots.  Oracle  Valid Values (for Apply method): pending-reboot . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.parameter.group.reset(ctx, db_parameter_group_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.parameter.group.reset db_parameter_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="reset_db_parameter_group",
        op_kwargs={
            "DBParameterGroupName": db_parameter_group_name,
            "ResetAllParameters": reset_all_parameters,
            "Parameters": parameters,
        },
    )
