"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def download(
    hub,
    ctx,
    db_instance_identifier: str,
    log_file_name: str,
    marker: str = None,
    number_of_lines: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Downloads all or a portion of the specified log file, up to 1 MB in size.

    Args:
        db_instance_identifier(str): The customer-assigned name of the DB instance that contains the log files you want to list. Constraints:   Must match the identifier of an existing DBInstance.  .
        log_file_name(str): The name of the log file to be downloaded.
        marker(str, optional): The pagination token provided in the previous request or "0". If the Marker parameter is specified the response includes only records beyond the marker until the end of the file or up to NumberOfLines. Defaults to None.
        number_of_lines(int, optional): The number of lines to download. If the number of lines specified results in a file over 1 MB in size, the file is truncated at 1 MB in size. If the NumberOfLines parameter is specified, then the block of lines returned can be from the beginning or the end of the log file, depending on the value of the Marker parameter.   If neither Marker or NumberOfLines are specified, the entire log file is returned up to a maximum of 10000 lines, starting with the most recent log entries first.   If NumberOfLines is specified and Marker isn't specified, then the most recent lines from the end of the log file are returned.   If Marker is specified as "0", then the specified number of lines from the beginning of the log file are returned.   You can download the log file in blocks of lines by specifying the size of the block using the NumberOfLines parameter, and by specifying a value of "0" for the Marker parameter in your first request. Include the Marker value returned in the response as the Marker value for the next request, continuing until the AdditionalDataPending response element returns false.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.log_file.portion.download(
                ctx, db_instance_identifier=value, log_file_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.log_file.portion.download db_instance_identifier=value, log_file_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="download_db_log_file_portion",
        op_kwargs={
            "DBInstanceIdentifier": db_instance_identifier,
            "LogFileName": log_file_name,
            "Marker": marker,
            "NumberOfLines": number_of_lines,
        },
    )
