"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    db_instance_identifier: str,
    filename_contains: str = None,
    file_last_written: int = None,
    file_size: int = None,
    filters: List = None,
    max_records: int = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of DB log files for the DB instance.

    Args:
        db_instance_identifier(str): The customer-assigned name of the DB instance that contains the log files you want to list. Constraints:   Must match the identifier of an existing DBInstance.  .
        filename_contains(str, optional): Filters the available log files for log file names that contain the specified string. Defaults to None.
        file_last_written(int, optional): Filters the available log files for files written since the specified date, in POSIX timestamp format with milliseconds. Defaults to None.
        file_size(int, optional): Filters the available log files for files larger than the specified size. Defaults to None.
        filters(List, optional): This parameter isn't currently supported. Defaults to None.
        max_records(int, optional): The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so you can retrieve the remaining results. Defaults to None.
        marker(str, optional): The pagination token provided in the previous request. If this parameter is specified the response includes only records beyond the marker, up to MaxRecords. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.log_file.init.describe_all(
                ctx, db_instance_identifier=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.log_file.init.describe_all db_instance_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="describe_db_log_files",
        op_kwargs={
            "DBInstanceIdentifier": db_instance_identifier,
            "FilenameContains": filename_contains,
            "FileLastWritten": file_last_written,
            "FileSize": file_size,
            "Filters": filters,
            "MaxRecords": max_records,
            "Marker": marker,
        },
    )
