"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def restore(
    hub,
    ctx,
    db_instance_identifier: str,
    db_instance_class: str,
    engine: str,
    source_engine: str,
    source_engine_version: str,
    s3_bucket_name: str,
    s3_ingestion_role_arn: str,
    db_name: str = None,
    allocated_storage: int = None,
    master_username: str = None,
    master_user_password: str = None,
    db_security_groups: List = None,
    vpc_security_group_ids: List = None,
    availability_zone: str = None,
    db_subnet_group_name: str = None,
    preferred_maintenance_window: str = None,
    db_parameter_group_name: str = None,
    backup_retention_period: int = None,
    preferred_backup_window: str = None,
    port: int = None,
    multi_az: bool = None,
    engine_version: str = None,
    auto_minor_version_upgrade: bool = None,
    license_model: str = None,
    iops: int = None,
    option_group_name: str = None,
    publicly_accessible: bool = None,
    tags: List = None,
    storage_type: str = None,
    storage_encrypted: bool = None,
    kms_key_id: str = None,
    copy_tags_to_snapshot: bool = None,
    monitoring_interval: int = None,
    monitoring_role_arn: str = None,
    enable_iam_database_authentication: bool = None,
    s3_prefix: str = None,
    enable_performance_insights: bool = None,
    performance_insights_kms_key_id: str = None,
    performance_insights_retention_period: int = None,
    enable_cloudwatch_logs_exports: List = None,
    processor_features: List = None,
    use_default_processor_features: bool = None,
    deletion_protection: bool = None,
    max_allocated_storage: int = None,
) -> Dict:
    r'''
    **Autogenerated function**

    Amazon Relational Database Service (Amazon RDS) supports importing MySQL databases by using backup files. You can create a backup of your on-premises database, store it on Amazon Simple Storage Service (Amazon S3), and then restore the backup file onto a new Amazon RDS DB instance running MySQL. For more information, see Importing Data into an Amazon RDS MySQL DB Instance in the Amazon RDS User Guide.

    Args:
        db_name(str, optional): The name of the database to create when the DB instance is created. Follow the naming rules specified in CreateDBInstance. . Defaults to None.
        db_instance_identifier(str): The DB instance identifier. This parameter is stored as a lowercase string.  Constraints:   Must contain from 1 to 63 letters, numbers, or hyphens.   First character must be a letter.   Can't end with a hyphen or contain two consecutive hyphens.   Example: mydbinstance .
        allocated_storage(int, optional): The amount of storage (in gigabytes) to allocate initially for the DB instance. Follow the allocation rules specified in CreateDBInstance.   Be sure to allocate enough memory for your new DB instance so that the restore operation can succeed. You can also allocate additional memory for future growth.  . Defaults to None.
        db_instance_class(str): The compute and memory capacity of the DB instance, for example, db.m4.large. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see DB Instance Class in the Amazon RDS User Guide.  Importing from Amazon S3 isn't supported on the db.t2.micro DB instance class. .
        engine(str): The name of the database engine to be used for this instance.  Valid Values: mysql .
        master_username(str, optional): The name for the master user.  Constraints:    Must be 1 to 16 letters or numbers.   First character must be a letter.   Can't be a reserved word for the chosen database engine.  . Defaults to None.
        master_user_password(str, optional): The password for the master user. The password can include any printable ASCII character except "/", """, or "@".  Constraints: Must contain from 8 to 41 characters. Defaults to None.
        db_security_groups(List, optional): A list of DB security groups to associate with this DB instance. Default: The default DB security group for the database engine. Defaults to None.
        vpc_security_group_ids(List, optional): A list of VPC security groups to associate with this DB instance. . Defaults to None.
        availability_zone(str, optional): The Availability Zone that the DB instance is created in. For information about Amazon Web Services Regions and Availability Zones, see Regions and Availability Zones in the Amazon RDS User Guide.  Default: A random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region.   Example: us-east-1d  Constraint: The AvailabilityZone parameter can't be specified if the DB instance is a Multi-AZ deployment. The specified Availability Zone must be in the same Amazon Web Services Region as the current endpoint. . Defaults to None.
        db_subnet_group_name(str, optional): A DB subnet group to associate with this DB instance. Defaults to None.
        preferred_maintenance_window(str, optional): The time range each week during which system maintenance can occur, in Universal Coordinated Time (UTC). For more information, see Amazon RDS Maintenance Window in the Amazon RDS User Guide.  Constraints:   Must be in the format ddd:hh24:mi-ddd:hh24:mi.   Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.   Must be in Universal Coordinated Time (UTC).   Must not conflict with the preferred backup window.   Must be at least 30 minutes.  . Defaults to None.
        db_parameter_group_name(str, optional): The name of the DB parameter group to associate with this DB instance. If you do not specify a value for DBParameterGroupName, then the default DBParameterGroup for the specified DB engine is used. Defaults to None.
        backup_retention_period(int, optional): The number of days for which automated backups are retained. Setting this parameter to a positive number enables backups. For more information, see CreateDBInstance. . Defaults to None.
        preferred_backup_window(str, optional): The time range each day during which automated backups are created if automated backups are enabled. For more information, see Backup window in the Amazon RDS User Guide.  Constraints:   Must be in the format hh24:mi-hh24:mi.   Must be in Universal Coordinated Time (UTC).   Must not conflict with the preferred maintenance window.   Must be at least 30 minutes.  . Defaults to None.
        port(int, optional): The port number on which the database accepts connections.  Type: Integer  Valid Values: 1150-65535  Default: 3306 . Defaults to None.
        multi_az(bool, optional): A value that indicates whether the DB instance is a Multi-AZ deployment. If the DB instance is a Multi-AZ deployment, you can't set the AvailabilityZone parameter. . Defaults to None.
        engine_version(str, optional): The version number of the database engine to use. Choose the latest minor version of your database engine. For information about engine versions, see CreateDBInstance, or call DescribeDBEngineVersions. . Defaults to None.
        auto_minor_version_upgrade(bool, optional): A value that indicates whether minor engine upgrades are applied automatically to the DB instance during the maintenance window. By default, minor engine upgrades are not applied automatically. . Defaults to None.
        license_model(str, optional): The license model for this DB instance. Use general-public-license. . Defaults to None.
        iops(int, optional): The amount of Provisioned IOPS (input/output operations per second) to allocate initially for the DB instance. For information about valid Iops values, see Amazon RDS Provisioned IOPS Storage to Improve Performance in the Amazon RDS User Guide. . Defaults to None.
        option_group_name(str, optional): The name of the option group to associate with this DB instance. If this argument is omitted, the default option group for the specified engine is used. . Defaults to None.
        publicly_accessible(bool, optional): A value that indicates whether the DB instance is publicly accessible. When the DB instance is publicly accessible, its DNS endpoint resolves to the private IP address from within the DB instance's VPC, and to the public IP address from outside of the DB instance's VPC. Access to the DB instance is ultimately controlled by the security group it uses, and that public access is not permitted if the security group assigned to the DB instance doesn't permit it. When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address. For more information, see CreateDBInstance. Defaults to None.
        tags(List, optional): A list of tags to associate with this DB instance. For more information, see Tagging Amazon RDS Resources in the Amazon RDS User Guide. . Defaults to None.
        storage_type(str, optional): Specifies the storage type to be associated with the DB instance.  Valid values: standard | gp2 | io1  If you specify io1, you must also include a value for the Iops parameter.  Default: io1 if the Iops parameter is specified; otherwise gp2 . Defaults to None.
        storage_encrypted(bool, optional): A value that indicates whether the new DB instance is encrypted or not. . Defaults to None.
        kms_key_id(str, optional): The Amazon Web Services KMS key identifier for an encrypted DB instance.  The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon Web Services KMS customer master key (CMK). To use a CMK in a different Amazon Web Services account, specify the key ARN or alias ARN. If the StorageEncrypted parameter is enabled, and you do not specify a value for the KmsKeyId parameter, then Amazon RDS will use your default CMK. There is a default CMK for your Amazon Web Services account. Your Amazon Web Services account has a different default CMK for each Amazon Web Services Region. . Defaults to None.
        copy_tags_to_snapshot(bool, optional): A value that indicates whether to copy all tags from the DB instance to snapshots of the DB instance. By default, tags are not copied. . Defaults to None.
        monitoring_interval(int, optional): The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0.  If MonitoringRoleArn is specified, then you must also set MonitoringInterval to a value other than 0.  Valid Values: 0, 1, 5, 10, 15, 30, 60  Default: 0 . Defaults to None.
        monitoring_role_arn(str, optional): The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, arn:aws:iam:123456789012:role/emaccess. For information on creating a monitoring role, see Setting Up and Enabling Enhanced Monitoring in the Amazon RDS User Guide.  If MonitoringInterval is set to a value other than 0, then you must supply a MonitoringRoleArn value. . Defaults to None.
        enable_iam_database_authentication(bool, optional): A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping is disabled. For more information about IAM database authentication, see  IAM Database Authentication for MySQL and PostgreSQL in the Amazon RDS User Guide. . Defaults to None.
        source_engine(str): The name of the engine of your source database.  Valid Values: mysql .
        source_engine_version(str): The version of the database that the backup files were created from. MySQL versions 5.6 and 5.7 are supported.  Example: 5.6.40 .
        s3_bucket_name(str): The name of your Amazon S3 bucket that contains your database backup file. .
        s3_prefix(str, optional): The prefix of your Amazon S3 bucket. . Defaults to None.
        s3_ingestion_role_arn(str): An Amazon Web Services Identity and Access Management (IAM) role to allow Amazon RDS to access your Amazon S3 bucket. .
        enable_performance_insights(bool, optional): A value that indicates whether to enable Performance Insights for the DB instance.  For more information, see Using Amazon Performance Insights in the Amazon Relational Database Service User Guide. . Defaults to None.
        performance_insights_kms_key_id(str, optional): The Amazon Web Services KMS key identifier for encryption of Performance Insights data. The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon Web Services KMS customer master key (CMK). If you do not specify a value for PerformanceInsightsKMSKeyId, then Amazon RDS uses your default CMK. There is a default CMK for your Amazon Web Services account. Your Amazon Web Services account has a different default CMK for each Amazon Web Services Region. Defaults to None.
        performance_insights_retention_period(int, optional): The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years). . Defaults to None.
        enable_cloudwatch_logs_exports(List, optional): The list of logs that the restored DB instance is to export to CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see Publishing Database Logs to Amazon CloudWatch Logs in the Amazon RDS User Guide. Defaults to None.
        processor_features(List, optional): The number of CPU cores and the number of threads per core for the DB instance class of the DB instance. Defaults to None.
        use_default_processor_features(bool, optional): A value that indicates whether the DB instance class of the DB instance uses its default processor features. Defaults to None.
        deletion_protection(bool, optional): A value that indicates whether the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. For more information, see  Deleting a DB Instance. . Defaults to None.
        max_allocated_storage(int, optional): The upper limit to which Amazon RDS can automatically scale the storage of the DB instance. For more information about this setting, including limitations that apply to it, see  Managing capacity automatically with Amazon RDS storage autoscaling in the Amazon RDS User Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.instance.from_.s3.restore(
                ctx,
                db_instance_identifier=value,
                db_instance_class=value,
                engine=value,
                source_engine=value,
                source_engine_version=value,
                s3_bucket_name=value,
                s3_ingestion_role_arn=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.instance.from_.s3.restore db_instance_identifier=value, db_instance_class=value, engine=value, source_engine=value, source_engine_version=value, s3_bucket_name=value, s3_ingestion_role_arn=value
    '''
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="restore_db_instance_from_s3",
        op_kwargs={
            "DBName": db_name,
            "DBInstanceIdentifier": db_instance_identifier,
            "AllocatedStorage": allocated_storage,
            "DBInstanceClass": db_instance_class,
            "Engine": engine,
            "MasterUsername": master_username,
            "MasterUserPassword": master_user_password,
            "DBSecurityGroups": db_security_groups,
            "VpcSecurityGroupIds": vpc_security_group_ids,
            "AvailabilityZone": availability_zone,
            "DBSubnetGroupName": db_subnet_group_name,
            "PreferredMaintenanceWindow": preferred_maintenance_window,
            "DBParameterGroupName": db_parameter_group_name,
            "BackupRetentionPeriod": backup_retention_period,
            "PreferredBackupWindow": preferred_backup_window,
            "Port": port,
            "MultiAZ": multi_az,
            "EngineVersion": engine_version,
            "AutoMinorVersionUpgrade": auto_minor_version_upgrade,
            "LicenseModel": license_model,
            "Iops": iops,
            "OptionGroupName": option_group_name,
            "PubliclyAccessible": publicly_accessible,
            "Tags": tags,
            "StorageType": storage_type,
            "StorageEncrypted": storage_encrypted,
            "KmsKeyId": kms_key_id,
            "CopyTagsToSnapshot": copy_tags_to_snapshot,
            "MonitoringInterval": monitoring_interval,
            "MonitoringRoleArn": monitoring_role_arn,
            "EnableIAMDatabaseAuthentication": enable_iam_database_authentication,
            "SourceEngine": source_engine,
            "SourceEngineVersion": source_engine_version,
            "S3BucketName": s3_bucket_name,
            "S3Prefix": s3_prefix,
            "S3IngestionRoleArn": s3_ingestion_role_arn,
            "EnablePerformanceInsights": enable_performance_insights,
            "PerformanceInsightsKMSKeyId": performance_insights_kms_key_id,
            "PerformanceInsightsRetentionPeriod": performance_insights_retention_period,
            "EnableCloudwatchLogsExports": enable_cloudwatch_logs_exports,
            "ProcessorFeatures": processor_features,
            "UseDefaultProcessorFeatures": use_default_processor_features,
            "DeletionProtection": deletion_protection,
            "MaxAllocatedStorage": max_allocated_storage,
        },
    )
