"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def restore(
    hub,
    ctx,
    db_instance_identifier: str,
    db_snapshot_identifier: str,
    db_instance_class: str = None,
    port: int = None,
    availability_zone: str = None,
    db_subnet_group_name: str = None,
    multi_az: bool = None,
    publicly_accessible: bool = None,
    auto_minor_version_upgrade: bool = None,
    license_model: str = None,
    db_name: str = None,
    engine: str = None,
    iops: int = None,
    option_group_name: str = None,
    tags: List = None,
    storage_type: str = None,
    tde_credential_arn: str = None,
    tde_credential_password: str = None,
    vpc_security_group_ids: List = None,
    domain: str = None,
    copy_tags_to_snapshot: bool = None,
    domain_iam_role_name: str = None,
    enable_iam_database_authentication: bool = None,
    enable_cloudwatch_logs_exports: List = None,
    processor_features: List = None,
    use_default_processor_features: bool = None,
    db_parameter_group_name: str = None,
    deletion_protection: bool = None,
    enable_customer_owned_ip: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new DB instance from a DB snapshot. The target database is created from the source database restore point with most of the source's original configuration, including the default security group and DB parameter group. By default, the new DB instance is created as a Single-AZ deployment, except when the instance is a SQL Server instance that has an option group associated with mirroring. In this case, the instance becomes a Multi-AZ deployment, not a Single-AZ deployment. If you want to replace your original DB instance with the new, restored DB instance, then rename your original DB instance before you call the RestoreDBInstanceFromDBSnapshot action. RDS doesn't allow two DB instances with the same name. After you have renamed your original DB instance with a different identifier, then you can pass the original name of the DB instance as the DBInstanceIdentifier in the call to the RestoreDBInstanceFromDBSnapshot action. The result is that you replace the original DB instance with the DB instance created from the snapshot. If you are restoring from a shared manual DB snapshot, the DBSnapshotIdentifier must be the ARN of the shared DB snapshot.  This command doesn't apply to Aurora MySQL and Aurora PostgreSQL. For Aurora, use RestoreDBClusterFromSnapshot.

    Args:
        db_instance_identifier(str): Name of the DB instance to create from the DB snapshot. This parameter isn't case-sensitive. Constraints:   Must contain from 1 to 63 numbers, letters, or hyphens   First character must be a letter   Can't end with a hyphen or contain two consecutive hyphens   Example: my-snapshot-id .
        db_snapshot_identifier(str): The identifier for the DB snapshot to restore from. Constraints:   Must match the identifier of an existing DBSnapshot.   If you are restoring from a shared manual DB snapshot, the DBSnapshotIdentifier must be the ARN of the shared DB snapshot.  .
        db_instance_class(str, optional): The compute and memory capacity of the Amazon RDS DB instance, for example, db.m4.large. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see DB Instance Class in the Amazon RDS User Guide.  Default: The same DBInstanceClass as the original DB instance. Defaults to None.
        port(int, optional): The port number on which the database accepts connections. Default: The same port as the original DB instance Constraints: Value must be 1150-65535 . Defaults to None.
        availability_zone(str, optional): The Availability Zone (AZ) where the DB instance will be created. Default: A random, system-chosen Availability Zone. Constraint: You can't specify the AvailabilityZone parameter if the DB instance is a Multi-AZ deployment. Example: us-east-1a . Defaults to None.
        db_subnet_group_name(str, optional): The DB subnet group name to use for the new instance. Constraints: If supplied, must match the name of an existing DBSubnetGroup. Example: mySubnetgroup . Defaults to None.
        multi_az(bool, optional): A value that indicates whether the DB instance is a Multi-AZ deployment. Constraint: You can't specify the AvailabilityZone parameter if the DB instance is a Multi-AZ deployment. Defaults to None.
        publicly_accessible(bool, optional): A value that indicates whether the DB instance is publicly accessible. When the DB instance is publicly accessible, its DNS endpoint resolves to the private IP address from within the DB instance's VPC, and to the public IP address from outside of the DB instance's VPC. Access to the DB instance is ultimately controlled by the security group it uses, and that public access is not permitted if the security group assigned to the DB instance doesn't permit it. When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address. For more information, see CreateDBInstance. Defaults to None.
        auto_minor_version_upgrade(bool, optional): A value that indicates whether minor version upgrades are applied automatically to the DB instance during the maintenance window. Defaults to None.
        license_model(str, optional): License model information for the restored DB instance. Default: Same as source.  Valid values: license-included | bring-your-own-license | general-public-license . Defaults to None.
        db_name(str, optional): The database name for the restored DB instance.  This parameter doesn't apply to the MySQL, PostgreSQL, or MariaDB engines. . Defaults to None.
        engine(str, optional): The database engine to use for the new instance. Default: The same as source Constraint: Must be compatible with the engine of the source. For example, you can restore a MariaDB 10.1 DB instance from a MySQL 5.6 snapshot. Valid Values:    mariadb     mysql     oracle-ee     oracle-ee-cdb     oracle-se2     oracle-se2-cdb     postgres     sqlserver-ee     sqlserver-se     sqlserver-ex     sqlserver-web   . Defaults to None.
        iops(int, optional): Specifies the amount of provisioned IOPS for the DB instance, expressed in I/O operations per second. If this parameter isn't specified, the IOPS value is taken from the backup. If this parameter is set to 0, the new instance is converted to a non-PIOPS instance. The conversion takes additional time, though your DB instance is available for connections before the conversion starts.  The provisioned IOPS value must follow the requirements for your database engine. For more information, see Amazon RDS Provisioned IOPS Storage to Improve Performance in the Amazon RDS User Guide.  Constraints: Must be an integer greater than 1000. Defaults to None.
        option_group_name(str, optional): The name of the option group to be used for the restored DB instance. Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an option group, and that option group can't be removed from a DB instance once it is associated with a DB instance. Defaults to None.
        tags(List, optional): A list of tags. For more information, see Tagging Amazon RDS Resources in the Amazon RDS User Guide. . Defaults to None.
        storage_type(str, optional): Specifies the storage type to be associated with the DB instance.  Valid values: standard | gp2 | io1   If you specify io1, you must also include a value for the Iops parameter.   Default: io1 if the Iops parameter is specified, otherwise gp2 . Defaults to None.
        tde_credential_arn(str, optional): The ARN from the key store with which to associate the instance for TDE encryption. Defaults to None.
        tde_credential_password(str, optional): The password for the given ARN from the key store in order to access the device. Defaults to None.
        vpc_security_group_ids(List, optional):  A list of EC2 VPC security groups to associate with this DB instance.   Default: The default EC2 VPC security group for the DB subnet group's VPC. . Defaults to None.
        domain(str, optional): Specify the Active Directory directory ID to restore the DB instance in. The domain must be created prior to this operation. Currently, only MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain. For more information, see  Kerberos Authentication in the Amazon RDS User Guide. Defaults to None.
        copy_tags_to_snapshot(bool, optional): A value that indicates whether to copy all tags from the restored DB instance to snapshots of the DB instance. By default, tags are not copied. Defaults to None.
        domain_iam_role_name(str, optional): Specify the name of the IAM role to be used when making API calls to the Directory Service. Defaults to None.
        enable_iam_database_authentication(bool, optional): A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping is disabled. For more information about IAM database authentication, see  IAM Database Authentication for MySQL and PostgreSQL in the Amazon RDS User Guide. . Defaults to None.
        enable_cloudwatch_logs_exports(List, optional): The list of logs that the restored DB instance is to export to CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see Publishing Database Logs to Amazon CloudWatch Logs in the Amazon RDS User Guide. Defaults to None.
        processor_features(List, optional): The number of CPU cores and the number of threads per core for the DB instance class of the DB instance. Defaults to None.
        use_default_processor_features(bool, optional): A value that indicates whether the DB instance class of the DB instance uses its default processor features. Defaults to None.
        db_parameter_group_name(str, optional): The name of the DB parameter group to associate with this DB instance. If you do not specify a value for DBParameterGroupName, then the default DBParameterGroup for the specified DB engine is used. Constraints:   If supplied, must match the name of an existing DBParameterGroup.   Must be 1 to 255 letters, numbers, or hyphens.   First character must be a letter.   Can't end with a hyphen or contain two consecutive hyphens.  . Defaults to None.
        deletion_protection(bool, optional): A value that indicates whether the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. For more information, see  Deleting a DB Instance. . Defaults to None.
        enable_customer_owned_ip(bool, optional): A value that indicates whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB instance. A CoIP provides local or external connectivity to resources in your Outpost subnets through your on-premises network. For some use cases, a CoIP can provide lower latency for connections to the DB instance from outside of its virtual private cloud (VPC) on your local network. For more information about RDS on Outposts, see Working with Amazon RDS on Amazon Web Services Outposts in the Amazon RDS User Guide. For more information about CoIPs, see Customer-owned IP addresses in the Amazon Web Services Outposts User Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.instance.from_.db_snapshot.restore(
                ctx, db_instance_identifier=value, db_snapshot_identifier=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.instance.from_.db_snapshot.restore db_instance_identifier=value, db_snapshot_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="restore_db_instance_from_db_snapshot",
        op_kwargs={
            "DBInstanceIdentifier": db_instance_identifier,
            "DBSnapshotIdentifier": db_snapshot_identifier,
            "DBInstanceClass": db_instance_class,
            "Port": port,
            "AvailabilityZone": availability_zone,
            "DBSubnetGroupName": db_subnet_group_name,
            "MultiAZ": multi_az,
            "PubliclyAccessible": publicly_accessible,
            "AutoMinorVersionUpgrade": auto_minor_version_upgrade,
            "LicenseModel": license_model,
            "DBName": db_name,
            "Engine": engine,
            "Iops": iops,
            "OptionGroupName": option_group_name,
            "Tags": tags,
            "StorageType": storage_type,
            "TdeCredentialArn": tde_credential_arn,
            "TdeCredentialPassword": tde_credential_password,
            "VpcSecurityGroupIds": vpc_security_group_ids,
            "Domain": domain,
            "CopyTagsToSnapshot": copy_tags_to_snapshot,
            "DomainIAMRoleName": domain_iam_role_name,
            "EnableIAMDatabaseAuthentication": enable_iam_database_authentication,
            "EnableCloudwatchLogsExports": enable_cloudwatch_logs_exports,
            "ProcessorFeatures": processor_features,
            "UseDefaultProcessorFeatures": use_default_processor_features,
            "DBParameterGroupName": db_parameter_group_name,
            "DeletionProtection": deletion_protection,
            "EnableCustomerOwnedIp": enable_customer_owned_ip,
        },
    )
