"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def start(
    hub,
    ctx,
    source_db_instance_arn: str,
    backup_retention_period: int = None,
    kms_key_id: str = None,
    pre_signed_url: str = None,
    source_region: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Enables replication of automated backups to a different Amazon Web Services Region. For more information, see  Replicating Automated Backups to Another Amazon Web Services Region in the Amazon RDS User Guide.

    Args:
        source_db_instance_arn(str): The Amazon Resource Name (ARN) of the source DB instance for the replicated automated backups, for example, arn:aws:rds:us-west-2:123456789012:db:mydatabase.
        backup_retention_period(int, optional): The retention period for the replicated automated backups. Defaults to None.
        kms_key_id(str, optional): The Amazon Web Services KMS key identifier for encryption of the replicated automated backups. The KMS key ID is the Amazon Resource Name (ARN) for the KMS encryption key in the destination Amazon Web Services Region, for example, arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE. Defaults to None.
        pre_signed_url(str, optional): A URL that contains a Signature Version 4 signed request for the StartDBInstanceAutomatedBackupsReplication action to be called in the Amazon Web Services Region of the source DB instance. The presigned URL must be a valid request for the StartDBInstanceAutomatedBackupsReplication API action that can be executed in the Amazon Web Services Region that contains the source DB instance. Defaults to None.
        source_region(str, optional): The ID of the region that contains the source for the db instance. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.instance.automated_backup.replication.start(
                ctx, source_db_instance_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.instance.automated_backup.replication.start source_db_instance_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="start_db_instance_automated_backups_replication",
        op_kwargs={
            "SourceDBInstanceArn": source_db_instance_arn,
            "BackupRetentionPeriod": backup_retention_period,
            "KmsKeyId": kms_key_id,
            "PreSignedUrl": pre_signed_url,
            "SourceRegion": source_region,
        },
    )


async def stop(hub, ctx, source_db_instance_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Stops automated backup replication for a DB instance. For more information, see  Replicating Automated Backups to Another Amazon Web Services Region in the Amazon RDS User Guide.

    Args:
        source_db_instance_arn(str): The Amazon Resource Name (ARN) of the source DB instance for which to stop replicating automated backups, for example, arn:aws:rds:us-west-2:123456789012:db:mydatabase.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.instance.automated_backup.replication.stop(
                ctx, source_db_instance_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.instance.automated_backup.replication.stop source_db_instance_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="stop_db_instance_automated_backups_replication",
        op_kwargs={"SourceDBInstanceArn": source_db_instance_arn},
    )
