"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(
    hub, ctx, dbi_resource_id: str = None, db_instance_automated_backups_arn: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes automated backups using the DbiResourceId value of the source DB instance or the Amazon Resource Name (ARN) of the automated backups.

    Args:
        dbi_resource_id(str, optional): The identifier for the source DB instance, which can't be changed and which is unique to an Amazon Web Services Region. Defaults to None.
        db_instance_automated_backups_arn(str, optional): The Amazon Resource Name (ARN) of the automated backups to delete, for example, arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.instance.automated_backup.init.delete(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.instance.automated_backup.init.delete
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="delete_db_instance_automated_backup",
        op_kwargs={
            "DbiResourceId": dbi_resource_id,
            "DBInstanceAutomatedBackupsArn": db_instance_automated_backups_arn,
        },
    )


async def describe_all(
    hub,
    ctx,
    dbi_resource_id: str = None,
    db_instance_identifier: str = None,
    filters: List = None,
    max_records: int = None,
    marker: str = None,
    db_instance_automated_backups_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Displays backups for both current and deleted instances. For example, use this operation to find details about automated backups for previously deleted instances. Current instances with retention periods greater than zero (0) are returned for both the DescribeDBInstanceAutomatedBackups and DescribeDBInstances operations. All parameters are optional.

    Args:
        dbi_resource_id(str, optional): The resource ID of the DB instance that is the source of the automated backup. This parameter isn't case-sensitive. . Defaults to None.
        db_instance_identifier(str, optional): (Optional) The user-supplied instance identifier. If this parameter is specified, it must match the identifier of an existing DB instance. It returns information from the specific DB instance' automated backup. This parameter isn't case-sensitive. . Defaults to None.
        filters(List, optional): A filter that specifies which resources to return based on status. Supported filters are the following:    status     active - automated backups for current instances    retained - automated backups for deleted instances and after backup replication is stopped    creating - automated backups that are waiting for the first automated snapshot to be available      db-instance-id - Accepts DB instance identifiers and Amazon Resource Names (ARNs). The results list includes only information about the DB instance automated backups identified by these ARNs.    dbi-resource-id - Accepts DB resource identifiers and Amazon Resource Names (ARNs). The results list includes only information about the DB instance resources identified by these ARNs.   Returns all resources by default. The status for each resource is specified in the response. Defaults to None.
        max_records(int, optional): The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so that you can retrieve the remaining results. Defaults to None.
        marker(str, optional): The pagination token provided in the previous request. If this parameter is specified the response includes only records beyond the marker, up to MaxRecords. Defaults to None.
        db_instance_automated_backups_arn(str, optional): The Amazon Resource Name (ARN) of the replicated automated backups, for example, arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.instance.automated_backup.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.instance.automated_backup.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="describe_db_instance_automated_backups",
        op_kwargs={
            "DbiResourceId": dbi_resource_id,
            "DBInstanceIdentifier": db_instance_identifier,
            "Filters": filters,
            "MaxRecords": max_records,
            "Marker": marker,
            "DBInstanceAutomatedBackupsArn": db_instance_automated_backups_arn,
        },
    )
