"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe_all(
    hub,
    ctx,
    engine: str = None,
    engine_version: str = None,
    db_parameter_group_family: str = None,
    filters: List = None,
    max_records: int = None,
    marker: str = None,
    default_only: bool = None,
    list_supported_character_sets: bool = None,
    list_supported_timezones: bool = None,
    include_all: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of the available DB engines.

    Args:
        engine(str, optional): The database engine to return. Valid Values:     aurora (for MySQL 5.6-compatible Aurora)    aurora-mysql (for MySQL 5.7-compatible Aurora)    aurora-postgresql     mariadb     mysql     oracle-ee     oracle-ee-cdb     oracle-se2     oracle-se2-cdb     postgres     sqlserver-ee     sqlserver-se     sqlserver-ex     sqlserver-web   . Defaults to None.
        engine_version(str, optional): The database engine version to return. Example: 5.1.49 . Defaults to None.
        db_parameter_group_family(str, optional): The name of a specific DB parameter group family to return details for. Constraints:   If supplied, must match an existing DBParameterGroupFamily.  . Defaults to None.
        filters(List, optional): This parameter isn't currently supported. Defaults to None.
        max_records(int, optional):  The maximum number of records to include in the response. If more than the MaxRecords value is available, a pagination token called a marker is included in the response so you can retrieve the remaining results.  Default: 100 Constraints: Minimum 20, maximum 100. Defaults to None.
        marker(str, optional):  An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. . Defaults to None.
        default_only(bool, optional): A value that indicates whether only the default version of the specified engine or engine and major version combination is returned. Defaults to None.
        list_supported_character_sets(bool, optional): A value that indicates whether to list the supported character sets for each engine version. If this parameter is enabled and the requested engine supports the CharacterSetName parameter for CreateDBInstance, the response includes a list of supported character sets for each engine version. . Defaults to None.
        list_supported_timezones(bool, optional): A value that indicates whether to list the supported time zones for each engine version. If this parameter is enabled and the requested engine supports the TimeZone parameter for CreateDBInstance, the response includes a list of supported time zones for each engine version. . Defaults to None.
        include_all(bool, optional): A value that indicates whether to include engine versions that aren't available in the list. The default is to list only available engine versions. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.engine_version.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.engine_version.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="describe_db_engine_versions",
        op_kwargs={
            "Engine": engine,
            "EngineVersion": engine_version,
            "DBParameterGroupFamily": db_parameter_group_family,
            "Filters": filters,
            "MaxRecords": max_records,
            "Marker": marker,
            "DefaultOnly": default_only,
            "ListSupportedCharacterSets": list_supported_character_sets,
            "ListSupportedTimezones": list_supported_timezones,
            "IncludeAll": include_all,
        },
    )
