"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def backtrack(
    hub,
    ctx,
    db_cluster_identifier: str,
    backtrack_to: str,
    force: bool = None,
    use_earliest_time_on_point_in_time_unavailable: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Backtracks a DB cluster to a specific time, without creating a new DB cluster. For more information on backtracking, see  Backtracking an Aurora DB Cluster in the Amazon Aurora User Guide.   This action only applies to Aurora MySQL DB clusters.

    Args:
        db_cluster_identifier(str): The DB cluster identifier of the DB cluster to be backtracked. This parameter is stored as a lowercase string. Constraints:   Must contain from 1 to 63 alphanumeric characters or hyphens.   First character must be a letter.   Can't end with a hyphen or contain two consecutive hyphens.   Example: my-cluster1 .
        backtrack_to(str): The timestamp of the time to backtrack the DB cluster to, specified in ISO 8601 format. For more information about ISO 8601, see the ISO8601 Wikipedia page.   If the specified time isn't a consistent time for the DB cluster, Aurora automatically chooses the nearest possible consistent time for the DB cluster.  Constraints:   Must contain a valid ISO 8601 timestamp.   Can't contain a timestamp set in the future.   Example: 2017-07-08T18:00Z .
        force(bool, optional): A value that indicates whether to force the DB cluster to backtrack when binary logging is enabled. Otherwise, an error occurs when binary logging is enabled. Defaults to None.
        use_earliest_time_on_point_in_time_unavailable(bool, optional): A value that indicates whether to backtrack the DB cluster to the earliest possible backtrack time when BacktrackTo is set to a timestamp earlier than the earliest backtrack time. When this parameter is disabled and BacktrackTo is set to a timestamp earlier than the earliest backtrack time, an error occurs. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.cluster.init.backtrack(
                ctx, db_cluster_identifier=value, backtrack_to=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.cluster.init.backtrack db_cluster_identifier=value, backtrack_to=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="backtrack_db_cluster",
        op_kwargs={
            "DBClusterIdentifier": db_cluster_identifier,
            "BacktrackTo": backtrack_to,
            "Force": force,
            "UseEarliestTimeOnPointInTimeUnavailable": use_earliest_time_on_point_in_time_unavailable,
        },
    )


async def create(
    hub,
    ctx,
    db_cluster_identifier: str,
    engine: str,
    availability_zones: List = None,
    backup_retention_period: int = None,
    character_set_name: str = None,
    database_name: str = None,
    db_cluster_parameter_group_name: str = None,
    vpc_security_group_ids: List = None,
    db_subnet_group_name: str = None,
    engine_version: str = None,
    port: int = None,
    master_username: str = None,
    master_user_password: str = None,
    option_group_name: str = None,
    preferred_backup_window: str = None,
    preferred_maintenance_window: str = None,
    replication_source_identifier: str = None,
    tags: List = None,
    storage_encrypted: bool = None,
    kms_key_id: str = None,
    pre_signed_url: str = None,
    enable_iam_database_authentication: bool = None,
    backtrack_window: int = None,
    enable_cloudwatch_logs_exports: List = None,
    engine_mode: str = None,
    scaling_configuration: Dict = None,
    deletion_protection: bool = None,
    global_cluster_identifier: str = None,
    enable_http_endpoint: bool = None,
    copy_tags_to_snapshot: bool = None,
    domain: str = None,
    domain_iam_role_name: str = None,
    enable_global_write_forwarding: bool = None,
    source_region: str = None,
) -> Dict:
    r'''
    **Autogenerated function**

    Creates a new Amazon Aurora DB cluster. You can use the ReplicationSourceIdentifier parameter to create the DB cluster as a read replica of another DB cluster or Amazon RDS MySQL or PostgreSQL DB instance. For cross-region replication where the DB cluster identified by ReplicationSourceIdentifier is encrypted, you must also specify the PreSignedUrl parameter. For more information on Amazon Aurora, see  What Is Amazon Aurora? in the Amazon Aurora User Guide.   This action only applies to Aurora DB clusters.

    Args:
        availability_zones(List, optional): A list of Availability Zones (AZs) where instances in the DB cluster can be created. For information on Amazon Web Services Regions and Availability Zones, see Choosing the Regions and Availability Zones in the Amazon Aurora User Guide. . Defaults to None.
        backup_retention_period(int, optional): The number of days for which automated backups are retained. Default: 1 Constraints:   Must be a value from 1 to 35  . Defaults to None.
        character_set_name(str, optional): A value that indicates that the DB cluster should be associated with the specified CharacterSet. Defaults to None.
        database_name(str, optional): The name for your database of up to 64 alphanumeric characters. If you do not provide a name, Amazon RDS doesn't create a database in the DB cluster you are creating. Defaults to None.
        db_cluster_identifier(str): The DB cluster identifier. This parameter is stored as a lowercase string. Constraints:   Must contain from 1 to 63 letters, numbers, or hyphens.   First character must be a letter.   Can't end with a hyphen or contain two consecutive hyphens.   Example: my-cluster1 .
        db_cluster_parameter_group_name(str, optional):  The name of the DB cluster parameter group to associate with this DB cluster. If you do not specify a value, then the default DB cluster parameter group for the specified DB engine and version is used.  Constraints:   If supplied, must match the name of an existing DB cluster parameter group.  . Defaults to None.
        vpc_security_group_ids(List, optional): A list of EC2 VPC security groups to associate with this DB cluster. Defaults to None.
        db_subnet_group_name(str, optional): A DB subnet group to associate with this DB cluster. Constraints: Must match the name of an existing DBSubnetGroup. Must not be default. Example: mySubnetgroup . Defaults to None.
        engine(str): The name of the database engine to be used for this DB cluster. Valid Values: aurora (for MySQL 5.6-compatible Aurora), aurora-mysql (for MySQL 5.7-compatible Aurora), and aurora-postgresql .
        engine_version(str, optional): The version number of the database engine to use. To list all of the available engine versions for aurora (for MySQL 5.6-compatible Aurora), use the following command:  aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions[].EngineVersion"  To list all of the available engine versions for aurora-mysql (for MySQL 5.7-compatible Aurora), use the following command:  aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"  To list all of the available engine versions for aurora-postgresql, use the following command:  aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"   Aurora MySQL  Example: 5.6.10a, 5.6.mysql_aurora.1.19.2, 5.7.12, 5.7.mysql_aurora.2.04.5   Aurora PostgreSQL  Example: 9.6.3, 10.7 . Defaults to None.
        port(int, optional): The port number on which the instances in the DB cluster accept connections.  Default: 3306 if engine is set as aurora or 5432 if set to aurora-postgresql. . Defaults to None.
        master_username(str, optional): The name of the master user for the DB cluster. Constraints:   Must be 1 to 16 letters or numbers.   First character must be a letter.   Can't be a reserved word for the chosen database engine.  . Defaults to None.
        master_user_password(str, optional): The password for the master database user. This password can contain any printable ASCII character except "/", """, or "@". Constraints: Must contain from 8 to 41 characters. Defaults to None.
        option_group_name(str, optional): A value that indicates that the DB cluster should be associated with the specified option group. Permanent options can't be removed from an option group. The option group can't be removed from a DB cluster once it is associated with a DB cluster. Defaults to None.
        preferred_backup_window(str, optional): The daily time range during which automated backups are created if automated backups are enabled using the BackupRetentionPeriod parameter.  The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region. To view the time blocks available, see  Backup window in the Amazon Aurora User Guide.  Constraints:   Must be in the format hh24:mi-hh24:mi.   Must be in Universal Coordinated Time (UTC).   Must not conflict with the preferred maintenance window.   Must be at least 30 minutes.  . Defaults to None.
        preferred_maintenance_window(str, optional): The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC). Format: ddd:hh24:mi-ddd:hh24:mi  The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week. To see the time blocks available, see  Adjusting the Preferred DB Cluster Maintenance Window in the Amazon Aurora User Guide.  Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun. Constraints: Minimum 30-minute window. Defaults to None.
        replication_source_identifier(str, optional): The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a read replica. Defaults to None.
        tags(List, optional): Tags to assign to the DB cluster. Defaults to None.
        storage_encrypted(bool, optional): A value that indicates whether the DB cluster is encrypted. Defaults to None.
        kms_key_id(str, optional): The Amazon Web Services KMS key identifier for an encrypted DB cluster. The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon Web Services KMS customer master key (CMK). To use a CMK in a different Amazon Web Services account, specify the key ARN or alias ARN. When a CMK isn't specified in KmsKeyId:   If ReplicationSourceIdentifier identifies an encrypted source, then Amazon RDS will use the CMK used to encrypt the source. Otherwise, Amazon RDS will use your default CMK.    If the StorageEncrypted parameter is enabled and ReplicationSourceIdentifier isn't specified, then Amazon RDS will use your default CMK.   There is a default CMK for your Amazon Web Services account. Your Amazon Web Services account has a different default CMK for each Amazon Web Services Region. If you create a read replica of an encrypted DB cluster in another Amazon Web Services Region, you must set KmsKeyId to a Amazon Web Services KMS key identifier that is valid in the destination Amazon Web Services Region. This CMK is used to encrypt the read replica in that Amazon Web Services Region. Defaults to None.
        pre_signed_url(str, optional): A URL that contains a Signature Version 4 signed request for the CreateDBCluster action to be called in the source Amazon Web Services Region where the DB cluster is replicated from. You only need to specify PreSignedUrl when you are performing cross-region replication from an encrypted DB cluster. The pre-signed URL must be a valid request for the CreateDBCluster API action that can be executed in the source Amazon Web Services Region that contains the encrypted DB cluster to be copied. The pre-signed URL request must contain the following parameter values:    KmsKeyId - The Amazon Web Services KMS key identifier for the key to use to encrypt the copy of the DB cluster in the destination Amazon Web Services Region. This should refer to the same Amazon Web Services KMS CMK for both the CreateDBCluster action that is called in the destination Amazon Web Services Region, and the action contained in the pre-signed URL.    DestinationRegion - The name of the Amazon Web Services Region that Aurora read replica will be created in.    ReplicationSourceIdentifier - The DB cluster identifier for the encrypted DB cluster to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you are copying an encrypted DB cluster from the us-west-2 Amazon Web Services Region, then your ReplicationSourceIdentifier would look like Example: arn:aws:rds:us-west-2:123456789012:cluster:aurora-cluster1.   To learn how to generate a Signature Version 4 signed request, see  Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4) and  Signature Version 4 Signing Process.  If you are using an Amazon Web Services SDK tool or the CLI, you can specify SourceRegion (or --source-region for the CLI) instead of specifying PreSignedUrl manually. Specifying SourceRegion autogenerates a pre-signed URL that is a valid request for the operation that can be executed in the source Amazon Web Services Region. . Defaults to None.
        enable_iam_database_authentication(bool, optional): A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping is disabled. For more information, see  IAM Database Authentication in the Amazon Aurora User Guide. . Defaults to None.
        backtrack_window(int, optional): The target backtrack window, in seconds. To disable backtracking, set this value to 0.   Currently, Backtrack is only supported for Aurora MySQL DB clusters.  Default: 0 Constraints:   If specified, this value must be set to a number from 0 to 259,200 (72 hours).  . Defaults to None.
        enable_cloudwatch_logs_exports(List, optional): The list of log types that need to be enabled for exporting to CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see Publishing Database Logs to Amazon CloudWatch Logs in the Amazon Aurora User Guide.  Aurora MySQL  Possible values are audit, error, general, and slowquery.   Aurora PostgreSQL  Possible value is postgresql. . Defaults to None.
        engine_mode(str, optional): The DB engine mode of the DB cluster, either provisioned, serverless, parallelquery, global, or multimaster. The parallelquery engine mode isn't required for Aurora MySQL version 1.23 and higher 1.x versions, and version 2.09 and higher 2.x versions. The global engine mode isn't required for Aurora MySQL version 1.22 and higher 1.x versions, and global engine mode isn't required for any 2.x versions. The multimaster engine mode only applies for DB clusters created with Aurora MySQL version 5.6.10a. For Aurora PostgreSQL, the global engine mode isn't required, and both the parallelquery and the multimaster engine modes currently aren't supported. Limitations and requirements apply to some DB engine modes. For more information, see the following sections in the Amazon Aurora User Guide:     Limitations of Aurora Serverless      Limitations of Parallel Query      Limitations of Aurora Global Databases      Limitations of Multi-Master Clusters   . Defaults to None.
        scaling_configuration(Dict, optional): For DB clusters in serverless DB engine mode, the scaling properties of the DB cluster. Defaults to None.
        deletion_protection(bool, optional): A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. Defaults to None.
        global_cluster_identifier(str, optional):  The global cluster ID of an Aurora cluster that becomes the primary cluster in the new global database cluster. . Defaults to None.
        enable_http_endpoint(bool, optional): A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless DB cluster. By default, the HTTP endpoint is disabled. When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora Serverless DB cluster. You can also query your database from inside the RDS console with the query editor. For more information, see Using the Data API for Aurora Serverless in the Amazon Aurora User Guide. Defaults to None.
        copy_tags_to_snapshot(bool, optional): A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster. The default is not to copy them. Defaults to None.
        domain(str, optional): The Active Directory directory ID to create the DB cluster in.  For Amazon Aurora DB clusters, Amazon RDS can use Kerberos Authentication to authenticate users that connect to the DB cluster. For more information, see Kerberos Authentication in the Amazon Aurora User Guide. . Defaults to None.
        domain_iam_role_name(str, optional): Specify the name of the IAM role to be used when making API calls to the Directory Service. Defaults to None.
        enable_global_write_forwarding(bool, optional): A value that indicates whether to enable this DB cluster to forward write operations to the primary cluster of an Aurora global database (GlobalCluster). By default, write operations are not allowed on Aurora DB clusters that are secondary clusters in an Aurora global database. You can set this value only on Aurora DB clusters that are members of an Aurora global database. With this parameter enabled, a secondary cluster can forward writes to the current primary cluster and the resulting changes are replicated back to this cluster. For the primary DB cluster of an Aurora global database, this value is used immediately if the primary is demoted by the FailoverGlobalCluster API operation, but it does nothing until then. . Defaults to None.
        source_region(str, optional): The ID of the region that contains the source for the db cluster. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.cluster.init.create(
                ctx, db_cluster_identifier=value, engine=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.cluster.init.create db_cluster_identifier=value, engine=value
    '''
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="create_db_cluster",
        op_kwargs={
            "AvailabilityZones": availability_zones,
            "BackupRetentionPeriod": backup_retention_period,
            "CharacterSetName": character_set_name,
            "DatabaseName": database_name,
            "DBClusterIdentifier": db_cluster_identifier,
            "DBClusterParameterGroupName": db_cluster_parameter_group_name,
            "VpcSecurityGroupIds": vpc_security_group_ids,
            "DBSubnetGroupName": db_subnet_group_name,
            "Engine": engine,
            "EngineVersion": engine_version,
            "Port": port,
            "MasterUsername": master_username,
            "MasterUserPassword": master_user_password,
            "OptionGroupName": option_group_name,
            "PreferredBackupWindow": preferred_backup_window,
            "PreferredMaintenanceWindow": preferred_maintenance_window,
            "ReplicationSourceIdentifier": replication_source_identifier,
            "Tags": tags,
            "StorageEncrypted": storage_encrypted,
            "KmsKeyId": kms_key_id,
            "PreSignedUrl": pre_signed_url,
            "EnableIAMDatabaseAuthentication": enable_iam_database_authentication,
            "BacktrackWindow": backtrack_window,
            "EnableCloudwatchLogsExports": enable_cloudwatch_logs_exports,
            "EngineMode": engine_mode,
            "ScalingConfiguration": scaling_configuration,
            "DeletionProtection": deletion_protection,
            "GlobalClusterIdentifier": global_cluster_identifier,
            "EnableHttpEndpoint": enable_http_endpoint,
            "CopyTagsToSnapshot": copy_tags_to_snapshot,
            "Domain": domain,
            "DomainIAMRoleName": domain_iam_role_name,
            "EnableGlobalWriteForwarding": enable_global_write_forwarding,
            "SourceRegion": source_region,
        },
    )


async def delete(
    hub,
    ctx,
    db_cluster_identifier: str,
    skip_final_snapshot: bool = None,
    final_db_snapshot_identifier: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    The DeleteDBCluster action deletes a previously provisioned DB cluster. When you delete a DB cluster, all automated backups for that DB cluster are deleted and can't be recovered. Manual DB cluster snapshots of the specified DB cluster are not deleted.  For more information on Amazon Aurora, see  What Is Amazon Aurora? in the Amazon Aurora User Guide.   This action only applies to Aurora DB clusters.

    Args:
        db_cluster_identifier(str): The DB cluster identifier for the DB cluster to be deleted. This parameter isn't case-sensitive. Constraints:   Must match an existing DBClusterIdentifier.  .
        skip_final_snapshot(bool, optional): A value that indicates whether to skip the creation of a final DB cluster snapshot before the DB cluster is deleted. If skip is specified, no DB cluster snapshot is created. If skip isn't specified, a DB cluster snapshot is created before the DB cluster is deleted. By default, skip isn't specified, and the DB cluster snapshot is created. By default, this parameter is disabled.  You must specify a FinalDBSnapshotIdentifier parameter if SkipFinalSnapshot is disabled. . Defaults to None.
        final_db_snapshot_identifier(str, optional):  The DB cluster snapshot identifier of the new DB cluster snapshot created when SkipFinalSnapshot is disabled.    Specifying this parameter and also skipping the creation of a final DB cluster snapshot with the SkipFinalShapshot parameter results in an error.  Constraints:   Must be 1 to 255 letters, numbers, or hyphens.   First character must be a letter   Can't end with a hyphen or contain two consecutive hyphens  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.cluster.init.delete(ctx, db_cluster_identifier=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.cluster.init.delete db_cluster_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="delete_db_cluster",
        op_kwargs={
            "DBClusterIdentifier": db_cluster_identifier,
            "SkipFinalSnapshot": skip_final_snapshot,
            "FinalDBSnapshotIdentifier": final_db_snapshot_identifier,
        },
    )


async def describe_all(
    hub,
    ctx,
    db_cluster_identifier: str = None,
    filters: List = None,
    max_records: int = None,
    marker: str = None,
    include_shared: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about provisioned Aurora DB clusters. This API supports pagination. For more information on Amazon Aurora, see  What Is Amazon Aurora? in the Amazon Aurora User Guide.   This operation can also return information for Amazon Neptune DB instances and Amazon DocumentDB instances.

    Args:
        db_cluster_identifier(str, optional): The user-supplied DB cluster identifier. If this parameter is specified, information from only the specific DB cluster is returned. This parameter isn't case-sensitive. Constraints:   If supplied, must match an existing DBClusterIdentifier.  . Defaults to None.
        filters(List, optional): A filter that specifies one or more DB clusters to describe. Supported filters:    clone-group-id - Accepts clone group identifiers. The results list will only include information about the DB clusters associated with these clone groups.    db-cluster-id - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs). The results list will only include information about the DB clusters identified by these ARNs.    domain - Accepts Active Directory directory IDs. The results list will only include information about the DB clusters associated with these domains.    engine - Accepts engine names. The results list will only include information about the DB clusters for these engines.  . Defaults to None.
        max_records(int, optional): The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so you can retrieve the remaining results.  Default: 100 Constraints: Minimum 20, maximum 100. Defaults to None.
        marker(str, optional): An optional pagination token provided by a previous DescribeDBClusters request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. . Defaults to None.
        include_shared(bool, optional): Optional Boolean parameter that specifies whether the output includes information about clusters shared from other Amazon Web Services accounts. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.cluster.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.cluster.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="describe_db_clusters",
        op_kwargs={
            "DBClusterIdentifier": db_cluster_identifier,
            "Filters": filters,
            "MaxRecords": max_records,
            "Marker": marker,
            "IncludeShared": include_shared,
        },
    )


async def failover(
    hub, ctx, db_cluster_identifier: str, target_db_instance_identifier: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Forces a failover for a DB cluster. A failover for a DB cluster promotes one of the Aurora Replicas (read-only instances) in the DB cluster to be the primary instance (the cluster writer). Amazon Aurora will automatically fail over to an Aurora Replica, if one exists, when the primary instance fails. You can force a failover when you want to simulate a failure of a primary instance for testing. Because each instance in a DB cluster has its own endpoint address, you will need to clean up and re-establish any existing connections that use those endpoint addresses when the failover is complete. For more information on Amazon Aurora, see  What Is Amazon Aurora? in the Amazon Aurora User Guide.   This action only applies to Aurora DB clusters.

    Args:
        db_cluster_identifier(str): A DB cluster identifier to force a failover for. This parameter isn't case-sensitive. Constraints:   Must match the identifier of an existing DBCluster.  .
        target_db_instance_identifier(str, optional): The name of the instance to promote to the primary instance. You must specify the instance identifier for an Aurora Replica in the DB cluster. For example, mydbcluster-replica1. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.cluster.init.failover(ctx, db_cluster_identifier=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.cluster.init.failover db_cluster_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="failover_db_cluster",
        op_kwargs={
            "DBClusterIdentifier": db_cluster_identifier,
            "TargetDBInstanceIdentifier": target_db_instance_identifier,
        },
    )


async def modify(
    hub,
    ctx,
    db_cluster_identifier: str,
    new_db_cluster_identifier: str = None,
    apply_immediately: bool = None,
    backup_retention_period: int = None,
    db_cluster_parameter_group_name: str = None,
    vpc_security_group_ids: List = None,
    port: int = None,
    master_user_password: str = None,
    option_group_name: str = None,
    preferred_backup_window: str = None,
    preferred_maintenance_window: str = None,
    enable_iam_database_authentication: bool = None,
    backtrack_window: int = None,
    cloudwatch_logs_export_configuration: Dict = None,
    engine_version: str = None,
    allow_major_version_upgrade: bool = None,
    db_instance_parameter_group_name: str = None,
    domain: str = None,
    domain_iam_role_name: str = None,
    scaling_configuration: Dict = None,
    deletion_protection: bool = None,
    enable_http_endpoint: bool = None,
    copy_tags_to_snapshot: bool = None,
    enable_global_write_forwarding: bool = None,
) -> Dict:
    r'''
    **Autogenerated function**

    Modify a setting for an Amazon Aurora DB cluster. You can change one or more database configuration parameters by specifying these parameters and the new values in the request. For more information on Amazon Aurora, see  What Is Amazon Aurora? in the Amazon Aurora User Guide.   This action only applies to Aurora DB clusters.

    Args:
        db_cluster_identifier(str): The DB cluster identifier for the cluster being modified. This parameter isn't case-sensitive. Constraints: This identifier must match the identifier of an existing DB cluster.
        new_db_cluster_identifier(str, optional): The new DB cluster identifier for the DB cluster when renaming a DB cluster. This value is stored as a lowercase string. Constraints:   Must contain from 1 to 63 letters, numbers, or hyphens   The first character must be a letter   Can't end with a hyphen or contain two consecutive hyphens   Example: my-cluster2 . Defaults to None.
        apply_immediately(bool, optional): A value that indicates whether the modifications in this request and any pending modifications are asynchronously applied as soon as possible, regardless of the PreferredMaintenanceWindow setting for the DB cluster. If this parameter is disabled, changes to the DB cluster are applied during the next maintenance window. The ApplyImmediately parameter only affects the EnableIAMDatabaseAuthentication, MasterUserPassword, and NewDBClusterIdentifier values. If the ApplyImmediately parameter is disabled, then changes to the EnableIAMDatabaseAuthentication, MasterUserPassword, and NewDBClusterIdentifier values are applied during the next maintenance window. All other changes are applied immediately, regardless of the value of the ApplyImmediately parameter. By default, this parameter is disabled. Defaults to None.
        backup_retention_period(int, optional): The number of days for which automated backups are retained. You must specify a minimum value of 1. Default: 1 Constraints:   Must be a value from 1 to 35  . Defaults to None.
        db_cluster_parameter_group_name(str, optional): The name of the DB cluster parameter group to use for the DB cluster. Defaults to None.
        vpc_security_group_ids(List, optional): A list of VPC security groups that the DB cluster will belong to. Defaults to None.
        port(int, optional): The port number on which the DB cluster accepts connections. Constraints: Value must be 1150-65535  Default: The same port as the original DB cluster. Defaults to None.
        master_user_password(str, optional): The new password for the master database user. This password can contain any printable ASCII character except "/", """, or "@". Constraints: Must contain from 8 to 41 characters. Defaults to None.
        option_group_name(str, optional): A value that indicates that the DB cluster should be associated with the specified option group. Changing this parameter doesn't result in an outage except in the following case, and the change is applied during the next maintenance window unless the ApplyImmediately is enabled for this request. If the parameter change results in an option group that enables OEM, this change can cause a brief (sub-second) period during which new connections are rejected but existing connections are not interrupted.  Permanent options can't be removed from an option group. The option group can't be removed from a DB cluster once it is associated with a DB cluster. Defaults to None.
        preferred_backup_window(str, optional): The daily time range during which automated backups are created if automated backups are enabled, using the BackupRetentionPeriod parameter.  The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region. To view the time blocks available, see  Backup window in the Amazon Aurora User Guide.  Constraints:   Must be in the format hh24:mi-hh24:mi.   Must be in Universal Coordinated Time (UTC).   Must not conflict with the preferred maintenance window.   Must be at least 30 minutes.  . Defaults to None.
        preferred_maintenance_window(str, optional): The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC). Format: ddd:hh24:mi-ddd:hh24:mi  The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week. To see the time blocks available, see  Adjusting the Preferred DB Cluster Maintenance Window in the Amazon Aurora User Guide.  Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun. Constraints: Minimum 30-minute window. Defaults to None.
        enable_iam_database_authentication(bool, optional): A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping is disabled. For more information, see  IAM Database Authentication in the Amazon Aurora User Guide. . Defaults to None.
        backtrack_window(int, optional): The target backtrack window, in seconds. To disable backtracking, set this value to 0.  Currently, Backtrack is only supported for Aurora MySQL DB clusters.  Default: 0 Constraints:   If specified, this value must be set to a number from 0 to 259,200 (72 hours).  . Defaults to None.
        cloudwatch_logs_export_configuration(Dict, optional): The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB cluster. Defaults to None.
        engine_version(str, optional): The version number of the database engine to which you want to upgrade. Changing this parameter results in an outage. The change is applied during the next maintenance window unless ApplyImmediately is enabled. To list all of the available engine versions for aurora (for MySQL 5.6-compatible Aurora), use the following command:  aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions[].EngineVersion"  To list all of the available engine versions for aurora-mysql (for MySQL 5.7-compatible Aurora), use the following command:  aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"  To list all of the available engine versions for aurora-postgresql, use the following command:  aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion" . Defaults to None.
        allow_major_version_upgrade(bool, optional): A value that indicates whether major version upgrades are allowed. Constraints: You must allow major version upgrades when specifying a value for the EngineVersion parameter that is a different major version than the DB cluster's current version. Defaults to None.
        db_instance_parameter_group_name(str, optional): The name of the DB parameter group to apply to all instances of the DB cluster.   When you apply a parameter group using the DBInstanceParameterGroupName parameter, the DB cluster isn't rebooted automatically. Also, parameter changes aren't applied during the next maintenance window but instead are applied immediately.  Default: The existing name setting Constraints:   The DB parameter group must be in the same DB parameter group family as this DB cluster.   The DBInstanceParameterGroupName parameter is only valid in combination with the AllowMajorVersionUpgrade parameter.  . Defaults to None.
        domain(str, optional): The Active Directory directory ID to move the DB cluster to. Specify none to remove the cluster from its current domain. The domain must be created prior to this operation.  For more information, see Kerberos Authentication in the Amazon Aurora User Guide. . Defaults to None.
        domain_iam_role_name(str, optional): Specify the name of the IAM role to be used when making API calls to the Directory Service. Defaults to None.
        scaling_configuration(Dict, optional): The scaling properties of the DB cluster. You can only modify scaling properties for DB clusters in serverless DB engine mode. Defaults to None.
        deletion_protection(bool, optional): A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. . Defaults to None.
        enable_http_endpoint(bool, optional): A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless DB cluster. By default, the HTTP endpoint is disabled. When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora Serverless DB cluster. You can also query your database from inside the RDS console with the query editor. For more information, see Using the Data API for Aurora Serverless in the Amazon Aurora User Guide. Defaults to None.
        copy_tags_to_snapshot(bool, optional): A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster. The default is not to copy them. Defaults to None.
        enable_global_write_forwarding(bool, optional): A value that indicates whether to enable this DB cluster to forward write operations to the primary cluster of an Aurora global database (GlobalCluster). By default, write operations are not allowed on Aurora DB clusters that are secondary clusters in an Aurora global database. You can set this value only on Aurora DB clusters that are members of an Aurora global database. With this parameter enabled, a secondary cluster can forward writes to the current primary cluster and the resulting changes are replicated back to this cluster. For the primary DB cluster of an Aurora global database, this value is used immediately if the primary is demoted by the FailoverGlobalCluster API operation, but it does nothing until then. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.cluster.init.modify(ctx, db_cluster_identifier=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.cluster.init.modify db_cluster_identifier=value
    '''
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="modify_db_cluster",
        op_kwargs={
            "DBClusterIdentifier": db_cluster_identifier,
            "NewDBClusterIdentifier": new_db_cluster_identifier,
            "ApplyImmediately": apply_immediately,
            "BackupRetentionPeriod": backup_retention_period,
            "DBClusterParameterGroupName": db_cluster_parameter_group_name,
            "VpcSecurityGroupIds": vpc_security_group_ids,
            "Port": port,
            "MasterUserPassword": master_user_password,
            "OptionGroupName": option_group_name,
            "PreferredBackupWindow": preferred_backup_window,
            "PreferredMaintenanceWindow": preferred_maintenance_window,
            "EnableIAMDatabaseAuthentication": enable_iam_database_authentication,
            "BacktrackWindow": backtrack_window,
            "CloudwatchLogsExportConfiguration": cloudwatch_logs_export_configuration,
            "EngineVersion": engine_version,
            "AllowMajorVersionUpgrade": allow_major_version_upgrade,
            "DBInstanceParameterGroupName": db_instance_parameter_group_name,
            "Domain": domain,
            "DomainIAMRoleName": domain_iam_role_name,
            "ScalingConfiguration": scaling_configuration,
            "DeletionProtection": deletion_protection,
            "EnableHttpEndpoint": enable_http_endpoint,
            "CopyTagsToSnapshot": copy_tags_to_snapshot,
            "EnableGlobalWriteForwarding": enable_global_write_forwarding,
        },
    )


async def start(hub, ctx, db_cluster_identifier: str) -> Dict:
    r"""
    **Autogenerated function**

    Starts an Amazon Aurora DB cluster that was stopped using the Amazon Web Services console, the stop-db-cluster CLI command, or the StopDBCluster action. For more information, see  Stopping and Starting an Aurora Cluster in the Amazon Aurora User Guide.   This action only applies to Aurora DB clusters.

    Args:
        db_cluster_identifier(str): The DB cluster identifier of the Amazon Aurora DB cluster to be started. This parameter is stored as a lowercase string.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.cluster.init.start(ctx, db_cluster_identifier=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.cluster.init.start db_cluster_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="start_db_cluster",
        op_kwargs={"DBClusterIdentifier": db_cluster_identifier},
    )


async def stop(hub, ctx, db_cluster_identifier: str) -> Dict:
    r"""
    **Autogenerated function**

     Stops an Amazon Aurora DB cluster. When you stop a DB cluster, Aurora retains the DB cluster's metadata, including its endpoints and DB parameter groups. Aurora also retains the transaction logs so you can do a point-in-time restore if necessary.  For more information, see  Stopping and Starting an Aurora Cluster in the Amazon Aurora User Guide.   This action only applies to Aurora DB clusters.

    Args:
        db_cluster_identifier(str): The DB cluster identifier of the Amazon Aurora DB cluster to be stopped. This parameter is stored as a lowercase string.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.cluster.init.stop(ctx, db_cluster_identifier=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.cluster.init.stop db_cluster_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="stop_db_cluster",
        op_kwargs={"DBClusterIdentifier": db_cluster_identifier},
    )
