"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def restore(
    hub,
    ctx,
    db_cluster_identifier: str,
    snapshot_identifier: str,
    engine: str,
    availability_zones: List = None,
    engine_version: str = None,
    port: int = None,
    db_subnet_group_name: str = None,
    database_name: str = None,
    option_group_name: str = None,
    vpc_security_group_ids: List = None,
    tags: List = None,
    kms_key_id: str = None,
    enable_iam_database_authentication: bool = None,
    backtrack_window: int = None,
    enable_cloudwatch_logs_exports: List = None,
    engine_mode: str = None,
    scaling_configuration: Dict = None,
    db_cluster_parameter_group_name: str = None,
    deletion_protection: bool = None,
    copy_tags_to_snapshot: bool = None,
    domain: str = None,
    domain_iam_role_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new DB cluster from a DB snapshot or DB cluster snapshot. This action only applies to Aurora DB clusters. The target DB cluster is created from the source snapshot with a default configuration. If you don't specify a security group, the new DB cluster is associated with the default security group.  This action only restores the DB cluster, not the DB instances for that DB cluster. You must invoke the CreateDBInstance action to create DB instances for the restored DB cluster, specifying the identifier of the restored DB cluster in DBClusterIdentifier. You can create DB instances only after the RestoreDBClusterFromSnapshot action has completed and the DB cluster is available.  For more information on Amazon Aurora, see  What Is Amazon Aurora? in the Amazon Aurora User Guide.   This action only applies to Aurora DB clusters.

    Args:
        availability_zones(List, optional): Provides the list of Availability Zones (AZs) where instances in the restored DB cluster can be created. Defaults to None.
        db_cluster_identifier(str): The name of the DB cluster to create from the DB snapshot or DB cluster snapshot. This parameter isn't case-sensitive. Constraints:   Must contain from 1 to 63 letters, numbers, or hyphens   First character must be a letter   Can't end with a hyphen or contain two consecutive hyphens   Example: my-snapshot-id .
        snapshot_identifier(str): The identifier for the DB snapshot or DB cluster snapshot to restore from. You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot. However, you can use only the ARN to specify a DB snapshot. Constraints:   Must match the identifier of an existing Snapshot.  .
        engine(str): The database engine to use for the new DB cluster. Default: The same as source Constraint: Must be compatible with the engine of the source.
        engine_version(str, optional): The version of the database engine to use for the new DB cluster. To list all of the available engine versions for aurora (for MySQL 5.6-compatible Aurora), use the following command:  aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions[].EngineVersion"  To list all of the available engine versions for aurora-mysql (for MySQL 5.7-compatible Aurora), use the following command:  aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"  To list all of the available engine versions for aurora-postgresql, use the following command:  aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"   If you aren't using the default engine version, then you must specify the engine version.   Aurora MySQL  Example: 5.6.10a, 5.6.mysql_aurora.1.19.2, 5.7.12, 5.7.mysql_aurora.2.04.5   Aurora PostgreSQL  Example: 9.6.3, 10.7 . Defaults to None.
        port(int, optional): The port number on which the new DB cluster accepts connections. Constraints: This value must be 1150-65535  Default: The same port as the original DB cluster. Defaults to None.
        db_subnet_group_name(str, optional): The name of the DB subnet group to use for the new DB cluster. Constraints: If supplied, must match the name of an existing DB subnet group. Example: mySubnetgroup . Defaults to None.
        database_name(str, optional): The database name for the restored DB cluster. Defaults to None.
        option_group_name(str, optional): The name of the option group to use for the restored DB cluster. Defaults to None.
        vpc_security_group_ids(List, optional): A list of VPC security groups that the new DB cluster will belong to. Defaults to None.
        tags(List, optional): The tags to be assigned to the restored DB cluster. Defaults to None.
        kms_key_id(str, optional): The Amazon Web Services KMS key identifier to use when restoring an encrypted DB cluster from a DB snapshot or DB cluster snapshot. The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon Web Services KMS customer master key (CMK). To use a CMK in a different Amazon Web Services account, specify the key ARN or alias ARN. When you don't specify a value for the KmsKeyId parameter, then the following occurs:   If the DB snapshot or DB cluster snapshot in SnapshotIdentifier is encrypted, then the restored DB cluster is encrypted using the Amazon Web Services KMS CMK that was used to encrypt the DB snapshot or DB cluster snapshot.   If the DB snapshot or DB cluster snapshot in SnapshotIdentifier isn't encrypted, then the restored DB cluster isn't encrypted.  . Defaults to None.
        enable_iam_database_authentication(bool, optional): A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping is disabled. For more information, see  IAM Database Authentication in the Amazon Aurora User Guide. . Defaults to None.
        backtrack_window(int, optional): The target backtrack window, in seconds. To disable backtracking, set this value to 0.  Currently, Backtrack is only supported for Aurora MySQL DB clusters.  Default: 0 Constraints:   If specified, this value must be set to a number from 0 to 259,200 (72 hours).  . Defaults to None.
        enable_cloudwatch_logs_exports(List, optional): The list of logs that the restored DB cluster is to export to Amazon CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see Publishing Database Logs to Amazon CloudWatch Logs  in the Amazon Aurora User Guide. Defaults to None.
        engine_mode(str, optional): The DB engine mode of the DB cluster, either provisioned, serverless, parallelquery, global, or multimaster. For more information, see  CreateDBCluster. Defaults to None.
        scaling_configuration(Dict, optional): For DB clusters in serverless DB engine mode, the scaling properties of the DB cluster. Defaults to None.
        db_cluster_parameter_group_name(str, optional): The name of the DB cluster parameter group to associate with this DB cluster. If this argument is omitted, the default DB cluster parameter group for the specified engine is used. Constraints:   If supplied, must match the name of an existing default DB cluster parameter group.   Must be 1 to 255 letters, numbers, or hyphens.   First character must be a letter.   Can't end with a hyphen or contain two consecutive hyphens.  . Defaults to None.
        deletion_protection(bool, optional): A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. . Defaults to None.
        copy_tags_to_snapshot(bool, optional): A value that indicates whether to copy all tags from the restored DB cluster to snapshots of the restored DB cluster. The default is not to copy them. Defaults to None.
        domain(str, optional): Specify the Active Directory directory ID to restore the DB cluster in. The domain must be created prior to this operation. Currently, only MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain. For more information, see  Kerberos Authentication in the Amazon RDS User Guide. . Defaults to None.
        domain_iam_role_name(str, optional): Specify the name of the IAM role to be used when making API calls to the Directory Service. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.cluster.from_.snapshot.restore(
                ctx, db_cluster_identifier=value, snapshot_identifier=value, engine=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.cluster.from_.snapshot.restore db_cluster_identifier=value, snapshot_identifier=value, engine=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="restore_db_cluster_from_snapshot",
        op_kwargs={
            "AvailabilityZones": availability_zones,
            "DBClusterIdentifier": db_cluster_identifier,
            "SnapshotIdentifier": snapshot_identifier,
            "Engine": engine,
            "EngineVersion": engine_version,
            "Port": port,
            "DBSubnetGroupName": db_subnet_group_name,
            "DatabaseName": database_name,
            "OptionGroupName": option_group_name,
            "VpcSecurityGroupIds": vpc_security_group_ids,
            "Tags": tags,
            "KmsKeyId": kms_key_id,
            "EnableIAMDatabaseAuthentication": enable_iam_database_authentication,
            "BacktrackWindow": backtrack_window,
            "EnableCloudwatchLogsExports": enable_cloudwatch_logs_exports,
            "EngineMode": engine_mode,
            "ScalingConfiguration": scaling_configuration,
            "DBClusterParameterGroupName": db_cluster_parameter_group_name,
            "DeletionProtection": deletion_protection,
            "CopyTagsToSnapshot": copy_tags_to_snapshot,
            "Domain": domain,
            "DomainIAMRoleName": domain_iam_role_name,
        },
    )
