"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def restore(
    hub,
    ctx,
    db_cluster_identifier: str,
    engine: str,
    master_username: str,
    master_user_password: str,
    source_engine: str,
    source_engine_version: str,
    s3_bucket_name: str,
    s3_ingestion_role_arn: str,
    availability_zones: List = None,
    backup_retention_period: int = None,
    character_set_name: str = None,
    database_name: str = None,
    db_cluster_parameter_group_name: str = None,
    vpc_security_group_ids: List = None,
    db_subnet_group_name: str = None,
    engine_version: str = None,
    port: int = None,
    option_group_name: str = None,
    preferred_backup_window: str = None,
    preferred_maintenance_window: str = None,
    tags: List = None,
    storage_encrypted: bool = None,
    kms_key_id: str = None,
    enable_iam_database_authentication: bool = None,
    s3_prefix: str = None,
    backtrack_window: int = None,
    enable_cloudwatch_logs_exports: List = None,
    deletion_protection: bool = None,
    copy_tags_to_snapshot: bool = None,
    domain: str = None,
    domain_iam_role_name: str = None,
) -> Dict:
    r'''
    **Autogenerated function**

    Creates an Amazon Aurora DB cluster from MySQL data stored in an Amazon S3 bucket. Amazon RDS must be authorized to access the Amazon S3 bucket and the data must be created using the Percona XtraBackup utility as described in  Migrating Data from MySQL by Using an Amazon S3 Bucket in the Amazon Aurora User Guide.  This action only restores the DB cluster, not the DB instances for that DB cluster. You must invoke the CreateDBInstance action to create DB instances for the restored DB cluster, specifying the identifier of the restored DB cluster in DBClusterIdentifier. You can create DB instances only after the RestoreDBClusterFromS3 action has completed and the DB cluster is available.  For more information on Amazon Aurora, see  What Is Amazon Aurora? in the Amazon Aurora User Guide.   This action only applies to Aurora DB clusters. The source DB engine must be MySQL.

    Args:
        availability_zones(List, optional): A list of Availability Zones (AZs) where instances in the restored DB cluster can be created. Defaults to None.
        backup_retention_period(int, optional): The number of days for which automated backups of the restored DB cluster are retained. You must specify a minimum value of 1. Default: 1 Constraints:   Must be a value from 1 to 35  . Defaults to None.
        character_set_name(str, optional): A value that indicates that the restored DB cluster should be associated with the specified CharacterSet. Defaults to None.
        database_name(str, optional): The database name for the restored DB cluster. Defaults to None.
        db_cluster_identifier(str): The name of the DB cluster to create from the source data in the Amazon S3 bucket. This parameter isn't case-sensitive. Constraints:   Must contain from 1 to 63 letters, numbers, or hyphens.   First character must be a letter.   Can't end with a hyphen or contain two consecutive hyphens.   Example: my-cluster1 .
        db_cluster_parameter_group_name(str, optional): The name of the DB cluster parameter group to associate with the restored DB cluster. If this argument is omitted, default.aurora5.6 is used.  Constraints:   If supplied, must match the name of an existing DBClusterParameterGroup.  . Defaults to None.
        vpc_security_group_ids(List, optional): A list of EC2 VPC security groups to associate with the restored DB cluster. Defaults to None.
        db_subnet_group_name(str, optional): A DB subnet group to associate with the restored DB cluster. Constraints: If supplied, must match the name of an existing DBSubnetGroup.  Example: mySubnetgroup . Defaults to None.
        engine(str): The name of the database engine to be used for this DB cluster. Valid Values: aurora (for MySQL 5.6-compatible Aurora), aurora-mysql (for MySQL 5.7-compatible Aurora), and aurora-postgresql .
        engine_version(str, optional): The version number of the database engine to use. To list all of the available engine versions for aurora (for MySQL 5.6-compatible Aurora), use the following command:  aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions[].EngineVersion"  To list all of the available engine versions for aurora-mysql (for MySQL 5.7-compatible Aurora), use the following command:  aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"  To list all of the available engine versions for aurora-postgresql, use the following command:  aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"   Aurora MySQL  Example: 5.6.10a, 5.6.mysql_aurora.1.19.2, 5.7.12, 5.7.mysql_aurora.2.04.5   Aurora PostgreSQL  Example: 9.6.3, 10.7 . Defaults to None.
        port(int, optional): The port number on which the instances in the restored DB cluster accept connections.  Default: 3306 . Defaults to None.
        master_username(str): The name of the master user for the restored DB cluster. Constraints:   Must be 1 to 16 letters or numbers.   First character must be a letter.   Can't be a reserved word for the chosen database engine.  .
        master_user_password(str): The password for the master database user. This password can contain any printable ASCII character except "/", """, or "@". Constraints: Must contain from 8 to 41 characters.
        option_group_name(str, optional): A value that indicates that the restored DB cluster should be associated with the specified option group. Permanent options can't be removed from an option group. An option group can't be removed from a DB cluster once it is associated with a DB cluster. Defaults to None.
        preferred_backup_window(str, optional): The daily time range during which automated backups are created if automated backups are enabled using the BackupRetentionPeriod parameter.  The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region. To view the time blocks available, see  Backup window in the Amazon Aurora User Guide.  Constraints:   Must be in the format hh24:mi-hh24:mi.   Must be in Universal Coordinated Time (UTC).   Must not conflict with the preferred maintenance window.   Must be at least 30 minutes.  . Defaults to None.
        preferred_maintenance_window(str, optional): The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC). Format: ddd:hh24:mi-ddd:hh24:mi  The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week. To see the time blocks available, see  Adjusting the Preferred Maintenance Window in the Amazon Aurora User Guide.  Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun. Constraints: Minimum 30-minute window. Defaults to None.
        tags(List, optional): A list of tags. For more information, see Tagging Amazon RDS Resources in the Amazon RDS User Guide. . Defaults to None.
        storage_encrypted(bool, optional): A value that indicates whether the restored DB cluster is encrypted. Defaults to None.
        kms_key_id(str, optional): The Amazon Web Services KMS key identifier for an encrypted DB cluster. The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon Web Services KMS customer master key (CMK). To use a CMK in a different Amazon Web Services account, specify the key ARN or alias ARN. If the StorageEncrypted parameter is enabled, and you do not specify a value for the KmsKeyId parameter, then Amazon RDS will use your default CMK. There is a default CMK for your Amazon Web Services account. Your Amazon Web Services account has a different default CMK for each Amazon Web Services Region. Defaults to None.
        enable_iam_database_authentication(bool, optional): A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping is disabled. For more information, see  IAM Database Authentication in the Amazon Aurora User Guide. . Defaults to None.
        source_engine(str): The identifier for the database engine that was backed up to create the files stored in the Amazon S3 bucket.  Valid values: mysql .
        source_engine_version(str): The version of the database that the backup files were created from. MySQL versions 5.5, 5.6, and 5.7 are supported.  Example: 5.6.40, 5.7.28 .
        s3_bucket_name(str): The name of the Amazon S3 bucket that contains the data used to create the Amazon Aurora DB cluster.
        s3_prefix(str, optional): The prefix for all of the file names that contain the data used to create the Amazon Aurora DB cluster. If you do not specify a SourceS3Prefix value, then the Amazon Aurora DB cluster is created by using all of the files in the Amazon S3 bucket. Defaults to None.
        s3_ingestion_role_arn(str): The Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that authorizes Amazon RDS to access the Amazon S3 bucket on your behalf.
        backtrack_window(int, optional): The target backtrack window, in seconds. To disable backtracking, set this value to 0.  Currently, Backtrack is only supported for Aurora MySQL DB clusters.  Default: 0 Constraints:   If specified, this value must be set to a number from 0 to 259,200 (72 hours).  . Defaults to None.
        enable_cloudwatch_logs_exports(List, optional): The list of logs that the restored DB cluster is to export to CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see Publishing Database Logs to Amazon CloudWatch Logs in the Amazon Aurora User Guide. Defaults to None.
        deletion_protection(bool, optional): A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled. . Defaults to None.
        copy_tags_to_snapshot(bool, optional): A value that indicates whether to copy all tags from the restored DB cluster to snapshots of the restored DB cluster. The default is not to copy them. Defaults to None.
        domain(str, optional): Specify the Active Directory directory ID to restore the DB cluster in. The domain must be created prior to this operation.   For Amazon Aurora DB clusters, Amazon RDS can use Kerberos Authentication to authenticate users that connect to the DB cluster. For more information, see Kerberos Authentication in the Amazon Aurora User Guide. . Defaults to None.
        domain_iam_role_name(str, optional): Specify the name of the IAM role to be used when making API calls to the Directory Service. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.cluster.from_.s3.restore(
                ctx,
                db_cluster_identifier=value,
                engine=value,
                master_username=value,
                master_user_password=value,
                source_engine=value,
                source_engine_version=value,
                s3_bucket_name=value,
                s3_ingestion_role_arn=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.cluster.from_.s3.restore db_cluster_identifier=value, engine=value, master_username=value, master_user_password=value, source_engine=value, source_engine_version=value, s3_bucket_name=value, s3_ingestion_role_arn=value
    '''
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="restore_db_cluster_from_s3",
        op_kwargs={
            "AvailabilityZones": availability_zones,
            "BackupRetentionPeriod": backup_retention_period,
            "CharacterSetName": character_set_name,
            "DatabaseName": database_name,
            "DBClusterIdentifier": db_cluster_identifier,
            "DBClusterParameterGroupName": db_cluster_parameter_group_name,
            "VpcSecurityGroupIds": vpc_security_group_ids,
            "DBSubnetGroupName": db_subnet_group_name,
            "Engine": engine,
            "EngineVersion": engine_version,
            "Port": port,
            "MasterUsername": master_username,
            "MasterUserPassword": master_user_password,
            "OptionGroupName": option_group_name,
            "PreferredBackupWindow": preferred_backup_window,
            "PreferredMaintenanceWindow": preferred_maintenance_window,
            "Tags": tags,
            "StorageEncrypted": storage_encrypted,
            "KmsKeyId": kms_key_id,
            "EnableIAMDatabaseAuthentication": enable_iam_database_authentication,
            "SourceEngine": source_engine,
            "SourceEngineVersion": source_engine_version,
            "S3BucketName": s3_bucket_name,
            "S3Prefix": s3_prefix,
            "S3IngestionRoleArn": s3_ingestion_role_arn,
            "BacktrackWindow": backtrack_window,
            "EnableCloudwatchLogsExports": enable_cloudwatch_logs_exports,
            "DeletionProtection": deletion_protection,
            "CopyTagsToSnapshot": copy_tags_to_snapshot,
            "Domain": domain,
            "DomainIAMRoleName": domain_iam_role_name,
        },
    )
