"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    db_cluster_identifier: str,
    db_cluster_endpoint_identifier: str,
    endpoint_type: str,
    static_members: List = None,
    excluded_members: List = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new custom endpoint and associates it with an Amazon Aurora DB cluster.  This action only applies to Aurora DB clusters.

    Args:
        db_cluster_identifier(str): The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.
        db_cluster_endpoint_identifier(str): The identifier to use for the new endpoint. This parameter is stored as a lowercase string.
        endpoint_type(str): The type of the endpoint. One of: READER, WRITER, ANY.
        static_members(List, optional): List of DB instance identifiers that are part of the custom endpoint group. Defaults to None.
        excluded_members(List, optional): List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty. Defaults to None.
        tags(List, optional): The tags to be assigned to the Amazon RDS resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.cluster.endpoint.create(
                ctx,
                db_cluster_identifier=value,
                db_cluster_endpoint_identifier=value,
                endpoint_type=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.cluster.endpoint.create db_cluster_identifier=value, db_cluster_endpoint_identifier=value, endpoint_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="create_db_cluster_endpoint",
        op_kwargs={
            "DBClusterIdentifier": db_cluster_identifier,
            "DBClusterEndpointIdentifier": db_cluster_endpoint_identifier,
            "EndpointType": endpoint_type,
            "StaticMembers": static_members,
            "ExcludedMembers": excluded_members,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, db_cluster_endpoint_identifier: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a custom endpoint and removes it from an Amazon Aurora DB cluster.  This action only applies to Aurora DB clusters.

    Args:
        db_cluster_endpoint_identifier(str): The identifier associated with the custom endpoint. This parameter is stored as a lowercase string.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.cluster.endpoint.delete(
                ctx, db_cluster_endpoint_identifier=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.cluster.endpoint.delete db_cluster_endpoint_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="delete_db_cluster_endpoint",
        op_kwargs={"DBClusterEndpointIdentifier": db_cluster_endpoint_identifier},
    )


async def describe_all(
    hub,
    ctx,
    db_cluster_identifier: str = None,
    db_cluster_endpoint_identifier: str = None,
    filters: List = None,
    max_records: int = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about endpoints for an Amazon Aurora DB cluster.  This action only applies to Aurora DB clusters.

    Args:
        db_cluster_identifier(str, optional): The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string. Defaults to None.
        db_cluster_endpoint_identifier(str, optional): The identifier of the endpoint to describe. This parameter is stored as a lowercase string. Defaults to None.
        filters(List, optional): A set of name-value pairs that define which endpoints to include in the output. The filters are specified as name-value pairs, in the format Name=endpoint_type,Values=endpoint_type1,endpoint_type2,.... Name can be one of: db-cluster-endpoint-type, db-cluster-endpoint-custom-type, db-cluster-endpoint-id, db-cluster-endpoint-status. Values for the  db-cluster-endpoint-type filter can be one or more of: reader, writer, custom. Values for the db-cluster-endpoint-custom-type filter can be one or more of: reader, any. Values for the db-cluster-endpoint-status filter can be one or more of: available, creating, deleting, inactive, modifying. . Defaults to None.
        max_records(int, optional): The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so you can retrieve the remaining results.  Default: 100 Constraints: Minimum 20, maximum 100. Defaults to None.
        marker(str, optional):  An optional pagination token provided by a previous DescribeDBClusterEndpoints request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.cluster.endpoint.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.cluster.endpoint.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="describe_db_cluster_endpoints",
        op_kwargs={
            "DBClusterIdentifier": db_cluster_identifier,
            "DBClusterEndpointIdentifier": db_cluster_endpoint_identifier,
            "Filters": filters,
            "MaxRecords": max_records,
            "Marker": marker,
        },
    )


async def modify(
    hub,
    ctx,
    db_cluster_endpoint_identifier: str,
    endpoint_type: str = None,
    static_members: List = None,
    excluded_members: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the properties of an endpoint in an Amazon Aurora DB cluster.  This action only applies to Aurora DB clusters.

    Args:
        db_cluster_endpoint_identifier(str): The identifier of the endpoint to modify. This parameter is stored as a lowercase string.
        endpoint_type(str, optional): The type of the endpoint. One of: READER, WRITER, ANY. Defaults to None.
        static_members(List, optional): List of DB instance identifiers that are part of the custom endpoint group. Defaults to None.
        excluded_members(List, optional): List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.db.cluster.endpoint.modify(
                ctx, db_cluster_endpoint_identifier=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.db.cluster.endpoint.modify db_cluster_endpoint_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="modify_db_cluster_endpoint",
        op_kwargs={
            "DBClusterEndpointIdentifier": db_cluster_endpoint_identifier,
            "EndpointType": endpoint_type,
            "StaticMembers": static_members,
            "ExcludedMembers": excluded_members,
        },
    )
