"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    custom_availability_zone_name: str,
    existing_vpn_id: str = None,
    new_vpn_tunnel_name: str = None,
    vpn_tunnel_originator_ip: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a custom Availability Zone (AZ). A custom AZ is an on-premises AZ that is integrated with a VMware vSphere cluster. For more information about RDS on VMware, see the  RDS on VMware User Guide.

    Args:
        custom_availability_zone_name(str): The name of the custom Availability Zone (AZ).
        existing_vpn_id(str, optional): The ID of an existing virtual private network (VPN) between the Amazon RDS website and the VMware vSphere cluster. Defaults to None.
        new_vpn_tunnel_name(str, optional): The name of a new VPN tunnel between the Amazon RDS website and the VMware vSphere cluster. Specify this parameter only if ExistingVpnId isn't specified. Defaults to None.
        vpn_tunnel_originator_ip(str, optional): The IP address of network traffic from your on-premises data center. A custom AZ receives the network traffic. Specify this parameter only if ExistingVpnId isn't specified. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.custom_availability_zone.create(
                ctx, custom_availability_zone_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.custom_availability_zone.create custom_availability_zone_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="create_custom_availability_zone",
        op_kwargs={
            "CustomAvailabilityZoneName": custom_availability_zone_name,
            "ExistingVpnId": existing_vpn_id,
            "NewVpnTunnelName": new_vpn_tunnel_name,
            "VpnTunnelOriginatorIP": vpn_tunnel_originator_ip,
        },
    )


async def delete(hub, ctx, custom_availability_zone_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a custom Availability Zone (AZ). A custom AZ is an on-premises AZ that is integrated with a VMware vSphere cluster. For more information about RDS on VMware, see the  RDS on VMware User Guide.

    Args:
        custom_availability_zone_id(str): The custom AZ identifier.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.custom_availability_zone.delete(
                ctx, custom_availability_zone_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.custom_availability_zone.delete custom_availability_zone_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="delete_custom_availability_zone",
        op_kwargs={"CustomAvailabilityZoneId": custom_availability_zone_id},
    )


async def describe_all(
    hub,
    ctx,
    custom_availability_zone_id: str = None,
    filters: List = None,
    max_records: int = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about custom Availability Zones (AZs). A custom AZ is an on-premises AZ that is integrated with a VMware vSphere cluster. For more information about RDS on VMware, see the  RDS on VMware User Guide.

    Args:
        custom_availability_zone_id(str, optional): The custom AZ identifier. If this parameter is specified, information from only the specific custom AZ is returned. Defaults to None.
        filters(List, optional): A filter that specifies one or more custom AZs to describe. Defaults to None.
        max_records(int, optional): The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so you can retrieve the remaining results. Default: 100 Constraints: Minimum 20, maximum 100. Defaults to None.
        marker(str, optional): An optional pagination token provided by a previous DescribeCustomAvailabilityZones request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.custom_availability_zone.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.custom_availability_zone.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="describe_custom_availability_zones",
        op_kwargs={
            "CustomAvailabilityZoneId": custom_availability_zone_id,
            "Filters": filters,
            "MaxRecords": max_records,
            "Marker": marker,
        },
    )
