"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def start(
    hub,
    ctx,
    resource_arn: str,
    mode: str,
    kms_key_id: str,
    apply_immediately: bool = None,
    engine_native_audit_fields_included: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts a database activity stream to monitor activity on the database. For more information, see Database Activity Streams in the Amazon Aurora User Guide.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) of the DB cluster, for example, arn:aws:rds:us-east-1:12345667890:cluster:das-cluster.
        mode(str): Specifies the mode of the database activity stream. Database events such as a change or access generate an activity stream event. The database session can handle these events either synchronously or asynchronously. .
        kms_key_id(str): The Amazon Web Services KMS key identifier for encrypting messages in the database activity stream. The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon Web Services KMS customer master key (CMK).
        apply_immediately(bool, optional): Specifies whether or not the database activity stream is to start as soon as possible, regardless of the maintenance window for the database. Defaults to None.
        engine_native_audit_fields_included(bool, optional): Specifies whether the database activity stream includes engine-native audit fields. This option only applies to an Oracle DB instance. By default, no engine-native audit fields are included. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.activity_stream.start(
                ctx, resource_arn=value, mode=value, kms_key_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.activity_stream.start resource_arn=value, mode=value, kms_key_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="start_activity_stream",
        op_kwargs={
            "ResourceArn": resource_arn,
            "Mode": mode,
            "KmsKeyId": kms_key_id,
            "ApplyImmediately": apply_immediately,
            "EngineNativeAuditFieldsIncluded": engine_native_audit_fields_included,
        },
    )


async def stop(hub, ctx, resource_arn: str, apply_immediately: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Stops a database activity stream that was started using the Amazon Web Services console, the start-activity-stream CLI command, or the StartActivityStream action. For more information, see Database Activity Streams in the Amazon Aurora User Guide.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) of the DB cluster for the database activity stream. For example, arn:aws:rds:us-east-1:12345667890:cluster:das-cluster. .
        apply_immediately(bool, optional): Specifies whether or not the database activity stream is to stop as soon as possible, regardless of the maintenance window for the database. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.rds.activity_stream.stop(ctx, resource_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.rds.activity_stream.stop resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="rds",
        operation="stop_activity_stream",
        op_kwargs={"ResourceArn": resource_arn, "ApplyImmediately": apply_immediately},
    )
