"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def enable(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Enables resource sharing within your AWS Organization. The caller must be the master account for the AWS Organization.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ram.sharing_with_aws_organization.enable(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ram.sharing_with_aws_organization.enable
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ram",
        operation="enable_sharing_with_aws_organization",
        op_kwargs={},
    )
