"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "type"


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the shareable resource types supported by AWS RAM.

    Args:
        next_token(str, optional): The token for the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ram.resource.type_.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ram.resource.type.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ram",
        operation="list_resource_types",
        op_kwargs={"nextToken": next_token, "maxResults": max_results},
    )
