"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(
    hub,
    ctx,
    resource_share_arn: str,
    permission_arn: str,
    replace: bool = None,
    client_token: str = None,
    permission_version: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Associates a permission with a resource share.

    Args:
        resource_share_arn(str): The Amazon Resource Name (ARN) of the resource share.
        permission_arn(str): The Amazon Resource Name (ARN) of the AWS RAM permissions to associate with the resource share.
        replace(bool, optional): Indicates whether the permission should replace the permissions that are currently associated with the resource share. Use true to replace the current permissions. Use false to add the permission to the current permission. Defaults to None.
        client_token(str, optional): A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Defaults to None.
        permission_version(int, optional): The version of the AWS RAM permissions to associate with the resource share. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ram.resource.share.permission.associate(
                ctx, resource_share_arn=value, permission_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ram.resource.share.permission.associate resource_share_arn=value, permission_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ram",
        operation="associate_resource_share_permission",
        op_kwargs={
            "resourceShareArn": resource_share_arn,
            "permissionArn": permission_arn,
            "replace": replace,
            "clientToken": client_token,
            "permissionVersion": permission_version,
        },
    )


async def disassociate(
    hub, ctx, resource_share_arn: str, permission_arn: str, client_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates an AWS RAM permission from a resource share.

    Args:
        resource_share_arn(str): The Amazon Resource Name (ARN) of the resource share.
        permission_arn(str): The ARN of the permission to disassociate from the resource share.
        client_token(str, optional): A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ram.resource.share.permission.disassociate(
                ctx, resource_share_arn=value, permission_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ram.resource.share.permission.disassociate resource_share_arn=value, permission_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ram",
        operation="disassociate_resource_share_permission",
        op_kwargs={
            "resourceShareArn": resource_share_arn,
            "permissionArn": permission_arn,
            "clientToken": client_token,
        },
    )


async def list_all(
    hub, ctx, resource_share_arn: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the AWS RAM permissions that are associated with a resource share.

    Args:
        resource_share_arn(str): The Amazon Resource Name (ARN) of the resource share.
        next_token(str, optional): The token for the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ram.resource.share.permission.list_all(
                ctx, resource_share_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ram.resource.share.permission.list_all resource_share_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ram",
        operation="list_resource_share_permissions",
        op_kwargs={
            "resourceShareArn": resource_share_arn,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
