"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def accept(
    hub, ctx, resource_share_invitation_arn: str, client_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Accepts an invitation to a resource share from another AWS account.

    Args:
        resource_share_invitation_arn(str): The Amazon Resource Name (ARN) of the invitation.
        client_token(str, optional): A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ram.resource.share.invitation.accept(
                ctx, resource_share_invitation_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ram.resource.share.invitation.accept resource_share_invitation_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ram",
        operation="accept_resource_share_invitation",
        op_kwargs={
            "resourceShareInvitationArn": resource_share_invitation_arn,
            "clientToken": client_token,
        },
    )


async def get_all(
    hub,
    ctx,
    resource_share_invitation_arns: List = None,
    resource_share_arns: List = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets the invitations that you have received for resource shares.

    Args:
        resource_share_invitation_arns(List, optional): The Amazon Resource Names (ARN) of the invitations. Defaults to None.
        resource_share_arns(List, optional): The Amazon Resource Names (ARN) of the resource shares. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ram.resource.share.invitation.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ram.resource.share.invitation.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ram",
        operation="get_resource_share_invitations",
        op_kwargs={
            "resourceShareInvitationArns": resource_share_invitation_arns,
            "resourceShareArns": resource_share_arns,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )


async def reject(
    hub, ctx, resource_share_invitation_arn: str, client_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Rejects an invitation to a resource share from another AWS account.

    Args:
        resource_share_invitation_arn(str): The Amazon Resource Name (ARN) of the invitation.
        client_token(str, optional): A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ram.resource.share.invitation.reject(
                ctx, resource_share_invitation_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ram.resource.share.invitation.reject resource_share_invitation_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ram",
        operation="reject_resource_share_invitation",
        op_kwargs={
            "resourceShareInvitationArn": resource_share_invitation_arn,
            "clientToken": client_token,
        },
    )
