"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def associate(
    hub,
    ctx,
    resource_share_arn: str,
    resource_arns: List = None,
    principals: List = None,
    client_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Associates the specified resource share with the specified principals and resources.

    Args:
        resource_share_arn(str): The Amazon Resource Name (ARN) of the resource share.
        resource_arns(List, optional): The Amazon Resource Names (ARN) of the resources. Defaults to None.
        principals(List, optional): The principals to associate with the resource share. The possible values are IDs of AWS accounts, and the ARNs of organizational units (OU) or organizations from AWS Organizations. Defaults to None.
        client_token(str, optional): A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ram.resource.share.init.associate(ctx, resource_share_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ram.resource.share.init.associate resource_share_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ram",
        operation="associate_resource_share",
        op_kwargs={
            "resourceShareArn": resource_share_arn,
            "resourceArns": resource_arns,
            "principals": principals,
            "clientToken": client_token,
        },
    )


async def create(
    hub,
    ctx,
    name: str,
    resource_arns: List = None,
    principals: List = None,
    tags: List = None,
    allow_external_principals: bool = None,
    client_token: str = None,
    permission_arns: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a resource share.

    Args:
        name(str): The name of the resource share.
        resource_arns(List, optional): The Amazon Resource Names (ARN) of the resources to associate with the resource share. Defaults to None.
        principals(List, optional): The principals to associate with the resource share. The possible values are IDs of AWS accounts, the ARN of an OU or organization from AWS Organizations. Defaults to None.
        tags(List, optional): One or more tags. Defaults to None.
        allow_external_principals(bool, optional): Indicates whether principals outside your AWS organization can be associated with a resource share. Defaults to None.
        client_token(str, optional): A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Defaults to None.
        permission_arns(List, optional): The ARNs of the permissions to associate with the resource share. If you do not specify an ARN for the permission, AWS RAM automatically attaches the default version of the permission for each resource type. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ram.resource.share.init.create(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ram.resource.share.init.create name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ram",
        operation="create_resource_share",
        op_kwargs={
            "name": name,
            "resourceArns": resource_arns,
            "principals": principals,
            "tags": tags,
            "allowExternalPrincipals": allow_external_principals,
            "clientToken": client_token,
            "permissionArns": permission_arns,
        },
    )


async def delete(hub, ctx, resource_share_arn: str, client_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified resource share.

    Args:
        resource_share_arn(str): The Amazon Resource Name (ARN) of the resource share.
        client_token(str, optional): A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ram.resource.share.init.delete(ctx, resource_share_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ram.resource.share.init.delete resource_share_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ram",
        operation="delete_resource_share",
        op_kwargs={"resourceShareArn": resource_share_arn, "clientToken": client_token},
    )


async def disassociate(
    hub,
    ctx,
    resource_share_arn: str,
    resource_arns: List = None,
    principals: List = None,
    client_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates the specified principals or resources from the specified resource share.

    Args:
        resource_share_arn(str): The Amazon Resource Name (ARN) of the resource share.
        resource_arns(List, optional): The Amazon Resource Names (ARNs) of the resources. Defaults to None.
        principals(List, optional): The principals. Defaults to None.
        client_token(str, optional): A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ram.resource.share.init.disassociate(
                ctx, resource_share_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ram.resource.share.init.disassociate resource_share_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ram",
        operation="disassociate_resource_share",
        op_kwargs={
            "resourceShareArn": resource_share_arn,
            "resourceArns": resource_arns,
            "principals": principals,
            "clientToken": client_token,
        },
    )


async def get_all(
    hub,
    ctx,
    resource_owner: str,
    resource_share_arns: List = None,
    resource_share_status: str = None,
    name: str = None,
    tag_filters: List = None,
    next_token: str = None,
    max_results: int = None,
    permission_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets the resource shares that you own or the resource shares that are shared with you.

    Args:
        resource_share_arns(List, optional): The ARNs of the resource shares. Defaults to None.
        resource_share_status(str, optional): The status of the resource share. Defaults to None.
        resource_owner(str): The type of owner.
        name(str, optional): The name of the resource share. Defaults to None.
        tag_filters(List, optional): One or more tag filters. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.
        permission_arn(str, optional): The Amazon Resource Name (ARN) of the AWS RAM permission that is associated with the resource share. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ram.resource.share.init.get_all(ctx, resource_owner=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ram.resource.share.init.get_all resource_owner=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ram",
        operation="get_resource_shares",
        op_kwargs={
            "resourceShareArns": resource_share_arns,
            "resourceShareStatus": resource_share_status,
            "resourceOwner": resource_owner,
            "name": name,
            "tagFilters": tag_filters,
            "nextToken": next_token,
            "maxResults": max_results,
            "permissionArn": permission_arn,
        },
    )


async def update(
    hub,
    ctx,
    resource_share_arn: str,
    name: str = None,
    allow_external_principals: bool = None,
    client_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the specified resource share that you own.

    Args:
        resource_share_arn(str): The Amazon Resource Name (ARN) of the resource share.
        name(str, optional): The name of the resource share. Defaults to None.
        allow_external_principals(bool, optional): Indicates whether principals outside your AWS organization can be associated with a resource share. Defaults to None.
        client_token(str, optional): A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ram.resource.share.init.update(ctx, resource_share_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ram.resource.share.init.update resource_share_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ram",
        operation="update_resource_share",
        op_kwargs={
            "resourceShareArn": resource_share_arn,
            "name": name,
            "allowExternalPrincipals": allow_external_principals,
            "clientToken": client_token,
        },
    )
