"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def promote(hub, ctx, resource_share_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Resource shares that were created by attaching a policy to a resource are visible only to the resource share owner, and the resource share cannot be modified in AWS RAM. Use this API action to promote the resource share. When you promote the resource share, it becomes:   Visible to all principals that it is shared with.   Modifiable in AWS RAM.

    Args:
        resource_share_arn(str): The ARN of the resource share to promote.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.ram.resource.share.created_from_policy.promote(
                ctx, resource_share_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.ram.resource.share.created_from_policy.promote resource_share_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="ram",
        operation="promote_resource_share_created_from_policy",
        op_kwargs={"resourceShareArn": resource_share_arn},
    )
